/************************************************************************
 * FILE:           clTmcTuner_Property_G_DIRECT_FREQUENCY.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_DIRECT_FREQUENCY.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_DIRECT_FREQUENCY.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_DIRECT_FREQUENCY.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_DIRECT_FREQUENCY::~clTmcTuner_Property_G_DIRECT_FREQUENCY()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_DIRECT_FREQUENCY::clTmcTuner_Property_G_DIRECT_FREQUENCY()
{
}

tVoid clTmcTuner_Property_G_DIRECT_FREQUENCY::vOnATFrequencyError(clCMError &oData)
{
    ETG_TRACE_USR4(( "clTmcTuner_Property_G_DIRECT_FREQUENCY::vOnATFrequencyError(), ErrorCode:%d ,ErrorInfo: %d, ", oData.getErrorCode(), oData.getErrorInfo()));
    clMuteImpl::instance()->vOnTuningActionError(Mute::MuteHandling::DIRECTFREQUENCY);
}
