/************************************************************************
 * FILE:           clTmcTuner_Property_G_CALIBRATION_DATA.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_CALIBRATION_DATA.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#ifndef clTmcTuner_Property_G_CALIBRATION_DATA_h
#define clTmcTuner_Property_G_CALIBRATION_DATA_h


#include "CcaApp/clServerProperty.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"

#define NO_PHYSICAL_TUNER   4

class clAars_CM_CalibrationData;
class clAars_CM_EvaluationParameter;

class clTmcTuner_Property_G_CALIBRATION_DATA : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
public:
    virtual ~clTmcTuner_Property_G_CALIBRATION_DATA();
    clTmcTuner_Property_G_CALIBRATION_DATA( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_CalibrationData* poCalibrationData, clAars_CM_EvaluationParameter* poEvaluationParameter);
    void vOnCalibrationStatus(clCMCalibrationDataStatus &oCalibrationData);
    tVoid vConstructSelfPostMessage(unsigned char* puchData);

protected:
    virtual tVoid vUpreg(amt_tclServiceData* poInMsg);
    virtual tVoid vGet(amt_tclServiceData* poInMsg);
    virtual tVoid vSet(amt_tclServiceData* poInMsg);

private:
    clAars_CM_CalibrationData* m_poCalibrationData;
    clAars_CM_EvaluationParameter* m_poEvaluationParameter;
    void vSetCalibrationDataValues(midw_fi_tcl_PhysicalTunerCalibData *poPhysicalTunerCalibData, unsigned char AvailableBands, tU16 u16FMCalibrationValue, tU16 u16AMCalibrationValue);
};



#endif /* clTmcTuner_Property_G_CALIBRATION_DATA_h */
