/************************************************************************
 * FILE:           clTmcTuner_Property_G_CALIBRATION_DATA.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_CALIBRATION_DATA.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_G_CALIBRATION_DATA.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_CalibrationData.h"
#include "Aars/clAars_CM_EvaluationParameter.h"
#include "tuner_trace.h"

using namespace tuner::CcaApp;

#include "tun_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_CALIBRATION_DATA.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_CALIBRATION_DATA::~clTmcTuner_Property_G_CALIBRATION_DATA()
{
    m_poCalibrationData = NULL;
    m_poEvaluationParameter = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_CALIBRATION_DATA::clTmcTuner_Property_G_CALIBRATION_DATA(clCCAhandler* poCCAhandler, clAars_CM_CalibrationData* poCalibrationData, clAars_CM_EvaluationParameter* poEvaluationParameter)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA, poCCAhandler)
     ,m_poCalibrationData(poCalibrationData)
     ,m_poEvaluationParameter(poEvaluationParameter)
{

}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_CALIBRATION_DATA::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_CALIBRATION_DATA::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_CALIBRATION_DATA::vGet(amt_tclServiceData* /*poInMsg*/)
{
    if(m_poCalibrationData != NULL)
    {
        m_poCalibrationData->vGetCalibrationData();
    }
}
//midw_fi_tcl_PhysicalTunerCalibData
void clTmcTuner_Property_G_CALIBRATION_DATA::vSetCalibrationDataValues(midw_fi_tcl_PhysicalTunerCalibData *poPhysicalTunerCalibData, unsigned char AvailableBands, tU16 u16FMCalibrationValue, tU16 u16AMCalibrationValue)
{
    ETG_TRACE_USR4(("clTmcTuner_Property_G_CALIBRATION_DATA::vOnCalibrationStatus :b8AvailableBands = 0x%x, u16FMCalibrationValue = 0x%x, u16AMCalibrationValue = 0x%x", AvailableBands, u16FMCalibrationValue, u16AMCalibrationValue));
    poPhysicalTunerCalibData->b8AvailableBands.u8Value = AvailableBands;
    poPhysicalTunerCalibData->u16FMCalibrationValue = u16FMCalibrationValue;
    poPhysicalTunerCalibData->u16AMCalibrationValue = u16AMCalibrationValue;
}

void clTmcTuner_Property_G_CALIBRATION_DATA::vOnCalibrationStatus(clCMCalibrationDataStatus &oCalibrationData)
{
    ETG_TRACE_USR4(("clTmcTuner_Property_G_CALIBRATION_DATA::vOnCalibrationStatus"));
    if(m_poEvaluationParameter == NULL)
    {
        NORMAL_M_ASSERT(m_poEvaluationParameter != NULL);
        return;
    }
    unsigned short iTunerID = 0x00;
    midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAStatus oMessage;

    vSetCalibrationDataValues(&oMessage.CalibrationDataValues.PhysicalTunerOne, m_poEvaluationParameter->pu8GetPhysicalTunerValue(iTunerID++), oCalibrationData.calival_FM1, oCalibrationData.calival_MW1);
    vSetCalibrationDataValues(&oMessage.CalibrationDataValues.PhysicalTunerTwo, m_poEvaluationParameter->pu8GetPhysicalTunerValue(iTunerID++), oCalibrationData.calival_FM2, oCalibrationData.calival_MW2);
    vSetCalibrationDataValues(&oMessage.CalibrationDataValues.PhysicalTunerThree, m_poEvaluationParameter->pu8GetPhysicalTunerValue(iTunerID++), oCalibrationData.calival_FM3, oCalibrationData.calival_MW3);
    vSetCalibrationDataValues(&oMessage.CalibrationDataValues.PhysicalTunerFour, m_poEvaluationParameter->pu8GetPhysicalTunerValue(iTunerID), oCalibrationData.calival_FM4, oCalibrationData.calival_MW4);

    /*This section will be removed when CalibrationData is removed from FI*/
    oMessage.CalibrationData.u8DataLength = 0;
    oMessage.CalibrationData.CalibrationValues.push_back(0x2000);
    oMessage.CalibrationData.CalibrationValues.push_back(0x2000);
    oMessage.CalibrationData.CalibrationValues.push_back(0x2000);
    oMessage.CalibrationData.CalibrationValues.push_back(0x2000);
    oMessage.CalibrationData.CalibrationValues.push_back(0x2000);
    vStatus(oMessage);
}

tVoid clTmcTuner_Property_G_CALIBRATION_DATA::vConstructSelfPostMessage(unsigned char* /*puchData*/)
{
    midw_tunerfi_tclMsgFID_TUN_G_CALIBRATION_DATAGet oMsg;
    ETG_TRACE_USR4((" clTmcTuner_Method_S_SET_PI::vConstructSelfPostMessage()"));
    vSendMessage(CCA_C_U16_APP_TUNER, oMsg, MIDW_TUNERFI_C_U16_FID_TUN_G_CALIBRATION_DATA, AMT_C_U8_CCAMSG_OPCODE_GET, 0, 0);
}

