/************************************************************************
 * FILE:           clTmcTuner_Property_G_AUDIO_SPLIT_MODE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Property_G_AUDIO_SPLIT_MODE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_SPLIT_MODE.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_EvaluationParameter.h"
#include "tuner_trace.h"
#include "kdsconfig/clConfigInterface.h"
#define AUDIO_SPLIT_MODE_PARAMETERID 0
#define ERROR_NOTAVAILABLE 0x000B

using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_AUDIO_SPLIT_MODE.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_AUDIO_SPLIT_MODE::~clTmcTuner_Property_G_AUDIO_SPLIT_MODE()
{
	m_poEvaluationParameter = 0;
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_AUDIO_SPLIT_MODE::clTmcTuner_Property_G_AUDIO_SPLIT_MODE(clCCAhandler* poCCAhandler, clAars_CM_EvaluationParameter* poEvaluationParameter,clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_SPLIT_MODE, poCCAhandler)
	 ,m_poEvaluationParameter(poEvaluationParameter)
	 ,m_poclConfigInterface(poclConfigInterface)
{

}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_SPLIT_MODE::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if(m_poclConfigInterface->u32GetConfigData("HDSupported"))
	{
		m_poEvaluationParameter->vGetHDSectionParameter(AUDIO_SPLIT_MODE_PARAMETERID);
	}
	else
	{
		vError(MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_SPLIT_MODE,ERROR_NOTAVAILABLE);
	}
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_SPLIT_MODE::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_SPLIT_MODE::vGet(amt_tclServiceData* /*poInMsg*/)
{
	if(!(m_poclConfigInterface->u32GetConfigData("HDSupported")))
	{
		vError(MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_SPLIT_MODE,ERROR_NOTAVAILABLE);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_G_AUDIO_SPLIT_MODE::vOnNewAudioSplitModeStatus(char s8ParameterValue)
{
   midw_tunerfi_tclMsgFID_TUN_G_AUDIO_SPLIT_MODEStatus oMessage;
   oMessage.e8ParameterValue.enType = (midw_fi_tcl_e8_Tun_AudioSplitMode::tenType)s8ParameterValue;

   ETG_TRACE_USR4(("clTmcTuner_Property_G_AUDIO_SPLIT_MODE::vOnNewAudioSplitModeStatus : ParameterValue = %d",oMessage.e8ParameterValue.enType ));
   vStatus(oMessage);
}
