/************************************************************************
 * FILE:           clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.cpp.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						auj1kor
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_defines.h"
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.cpp.trc.h"
#endif
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::~clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY(clCCAhandler* poCCAhandler)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_AUDIO_AMPLIFIER_FREQUENCY, poCCAhandler)
{
	m_u8SwitchingFrequencyMask = 0;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::vGet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	if(!m_u8SwitchingFrequencyMask)
		vSendSwitchingFrequency(TUN_SWITCHING_FREQUENCY_432kHz);
	else
		vSendSwitchingFrequency(m_u8SwitchingFrequencyMask);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::vSendSwitchingFrequency(tU8 u8SwitchingFrequencyMask)
{
	ETG_TRACE_USR4(( " clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY::vSendSwitchingFrequency : %d ", u8SwitchingFrequencyMask));
	if(m_u8SwitchingFrequencyMask != u8SwitchingFrequencyMask)
	{
      	midw_tunerfi_tclMsgFID_TUN_G_AUDIO_AMPLIFIER_FREQUENCYStatus oMessage;
		oMessage.b8SwitchingFrequencyMask.u8Value = u8SwitchingFrequencyMask;
		m_u8SwitchingFrequencyMask = u8SwitchingFrequencyMask;
		vStatus(oMessage);
	}
}


