/************************************************************************
 * FILE:          clTmcTuner_Property_DrmRadioText.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_DrmRadioText.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_DrmRadioText.h"
#include "CcaApp/clCCAhandler.h"
#include "datatypes/tString.h"
#include "Aars/clAars_CM_DRMCurrentRadiotext.h"
#include "kdsconfig/clConfigInterface.h"
#include "tuner_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Property_DrmRadioText.cpp.trc.h"
#endif
using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_DrmRadioText::~clTmcTuner_Property_DrmRadioText()
{
	m_poclAars_CM_DRMCurrentRadiotext = 0;
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_DrmRadioText::clTmcTuner_Property_DrmRadioText(clCCAhandler* poCCAhandler, clAars_CM_DRMCurrentRadiotext* poclAars_CM_DRMCurrentRadiotext, clConfigInterface* poclConfigInterface)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_RADIO_TEXT, poCCAhandler)
   ,m_poclConfigInterface(poclConfigInterface)
{
	m_poclAars_CM_DRMCurrentRadiotext=poclAars_CM_DRMCurrentRadiotext;
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_DrmRadioText::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_DrmRadioText::vGet(amt_tclServiceData* /*poInMsg*/)
{
	if ( m_poclConfigInterface!= NULL )
	{
		if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
		{
	if(m_poclAars_CM_DRMCurrentRadiotext!=0)
	{
		m_poclAars_CM_DRMCurrentRadiotext->vGetDRMCurrentRadiotext();
	}
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_RADIO_TEXT,ERROR_NOTAVAILABLE);
}
	}
}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_DrmRadioText::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
	ETG_TRACE_USR4(( "clTmcTuner_Property_DrmRadioText::vUpreg"));
	if ( m_poclConfigInterface!= NULL )
	{
		ETG_TRACE_USR4(( "clTmcTuner_Property_DrmRadioText::vUpreg 11"));
		if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
		{
	if(m_poclAars_CM_DRMCurrentRadiotext!=0)
	{
		m_poclAars_CM_DRMCurrentRadiotext->vGetDRMCurrentRadiotext();
			}
		}
		else
		{
			vError(MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_RADIO_TEXT,ERROR_NOTAVAILABLE);
		}
	}
}
void clTmcTuner_Property_DrmRadioText::vOnCM_DRMCurrentRadiotextStatus(tunerString sDRMCurrentRadioText)
{
	midw_tunerfi_tclMsgFID_TUN_G_DRM_RADIO_TEXTStatus oMessage;
	midw_fi_tclString sUtf8String = sDRMCurrentRadioText.c_str();
	oMessage.sDRMRadioText.bSet(sUtf8String,midw_fi_tclString::FI_EN_UTF8);
	vStatus(oMessage);

}

