/************************************************************************
 * FILE:           clTmcTuner_Property_DRM_TestMode.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_DRM_TestMode.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#ifndef clTmcTuner_Property_DRM_TestMode_h
#define clTmcTuner_Property_DRM_TestMode_h


#include "CcaApp/clServerProperty.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "ADRMsg/ADRMsg_if.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"


class clAars_DRMTestMode;


class clTmcTuner_Property_DRM_TestMode : public  tuner::CcaApp::clServerProperty, public clTmcTuner_HMI_ImpInterface
{
   public:
      virtual ~clTmcTuner_Property_DRM_TestMode();
      clTmcTuner_Property_DRM_TestMode( tuner::CcaApp::clCCAhandler* poCCAhandler);
      virtual void vOnNewDRMTestModeStatus(clCMDrmTestModeStatus &oData);
      void vResetMuteCounter();
   	  void vSetMuteCounter(unsigned short u16MuteCounter);
   	  unsigned short u16GetMuteCounter();
  	  unsigned short u16CalculateMuteCounter(unsigned char u8AudioMute);
  	  bool bIsAudioMuteEnabled(unsigned char u8AudioMute);
   	  void vIncrementMuteCounter();

   protected:
      virtual tVoid vUpreg(amt_tclServiceData* poInMsg);
      virtual tVoid vGet(amt_tclServiceData* poInMsg);
      virtual tVoid vSet(amt_tclServiceData* poInMsg);

      unsigned char u8PreviousAudioMuteValue;
  	  static unsigned short m_u16MuteCounter;

};

#endif
