/************************************************************************
 * FILE:           clTmcTuner_Property_DRM_TestMode.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Property_DRM_TestMode.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Property_DRM_TestMode.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_DRMTestMode.h"
#include "tun_defines.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Property_DRM_TestMode.cpp.trc.h"
#endif

using namespace tuner::CcaApp;
unsigned short clTmcTuner_Property_DRM_TestMode::m_u16MuteCounter = 0;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Property_DRM_TestMode::~clTmcTuner_Property_DRM_TestMode()
{
	u8PreviousAudioMuteValue = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Property_DRM_TestMode::clTmcTuner_Property_DRM_TestMode(clCCAhandler* poCCAhandler)
   : clServerProperty(MIDW_TUNERFI_C_U16_FID_TUN_G_DRM_TESTMODE, poCCAhandler)
{
	u8PreviousAudioMuteValue = 0;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DRM_TestMode::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus oMessage;
   vStatus(oMessage);
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DRM_TestMode::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Property_DRM_TestMode::vGet(amt_tclServiceData* /*poInMsg*/)
{

}

/**************************************************************************//**
*
******************************************************************************/
void clTmcTuner_Property_DRM_TestMode::vOnNewDRMTestModeStatus(clCMDrmTestModeStatus &oData)
{
   midw_tunerfi_tclMsgFID_TUN_G_DRM_TESTMODEStatus oMessage;
   oMessage.u8TunerInfo = oData.TunerInfo;
   oMessage.u32Frequency = oData.Frequency;
   oMessage.u8FieldStrength = oData.FieldStrength;
   oMessage.u8SyncStatus = oData.SyncStatus;
   oMessage.u8RobustnessMode = oData.RobustnessMode;
   oMessage.u32ChannelParams = oData.ChannelParams;
   oMessage.tU8ListDRMService = oData.Service;
   oMessage.sDRMServiceLabelData.bSet( oData.ServiceLabelData.c_str(),midw_fi_tclString::FI_EN_UTF8);
   oMessage.u32AudioConfig = oData.AudioConfig;
   oMessage.u8ProtectionLevels = oData.ProtectionLevels;
   oMessage.s32MSC_BER = oData.MSC_BER;
   oMessage.u8AudioCRCFails = oData.AudioCRCFails;
   oMessage.u8AudioMute = oData.AudioMute;
   oMessage.u8ServiceQuality = oData.ServiceQuality;
   oMessage.u16FAC_ERRS = oData.FAC_ERRS;
   oMessage.u8FAC_CRC_Fails = oData.FAC_CRC_Fails;
   oMessage.u16SDC_ERRS = oData.SDC_ERRS;
   oMessage.u8SDC_CRC_Fails = oData.SDC_CRC_Fails;
   oMessage.u16MuteCounter = u16CalculateMuteCounter(oData.AudioMute);

   ETG_TRACE_USR4(("TunerInfo=%d, Frequency=%d FieldStrength=%d SyncStatus=%d RobustnessMode=%d u32ChannelParams=%d",
		   oMessage.u8TunerInfo, oMessage.u32Frequency, oMessage.u8FieldStrength, oMessage.u8SyncStatus, oMessage.u8RobustnessMode, oMessage.u32ChannelParams));
   ETG_TRACE_USR4(("ServiceLabelData=%s", oMessage.sDRMServiceLabelData.szGet(midw_fi_tclString::FI_EN_UTF8)));
   ETG_TRACE_USR4(("AudioConfig=%d ProtectionLevels=%d MSC_BER=%d AudioCRCFails=%d AudioMute=%d ServiceQuality=%d",
		   oMessage.u32AudioConfig, oMessage.u8ProtectionLevels, oMessage.s32MSC_BER , oMessage.u8AudioCRCFails, oMessage.u8AudioMute, oMessage.u8ServiceQuality));
   ETG_TRACE_USR4(("FAC_ERRS=%d FAC_CRC_Fails=%d SDC_ERRS=%d SDC_CRC_Fails=%d MuteCounter=%d",
		   oMessage.u16FAC_ERRS, oMessage.u8FAC_CRC_Fails, oMessage.u16SDC_ERRS, oMessage.u8SDC_CRC_Fails, oMessage.u16MuteCounter));

   vStatus(oMessage);
}

/****************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_DRM_TestMode::vResetMuteCounter()
{
	//set back mute counter to 0 (reset is made using FID_TUN_S_DRM_RESET_MUTECOUNTER)
	vSetMuteCounter(0);
}
/****************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_DRM_TestMode::vSetMuteCounter(unsigned short u16MuteCounter)
{
	m_u16MuteCounter = u16MuteCounter;
}
/****************************************************************************
*
******************************************************************************/
unsigned short clTmcTuner_Property_DRM_TestMode::u16GetMuteCounter()
{
	return m_u16MuteCounter;
}
/****************************************************************************
*
******************************************************************************/
void clTmcTuner_Property_DRM_TestMode::vIncrementMuteCounter()
{
	(m_u16MuteCounter++);
}
/****************************************************************************
*
******************************************************************************/
unsigned short clTmcTuner_Property_DRM_TestMode::u16CalculateMuteCounter(unsigned char u8AudioMute)
{
	if(bIsAudioMuteEnabled(u8AudioMute))
	{
		ETG_TRACE_USR4(("AudioMute value is changed from 0 to 1"));
		vIncrementMuteCounter();
	}
	return u16GetMuteCounter();
}
/****************************************************************************
*
******************************************************************************/
bool clTmcTuner_Property_DRM_TestMode::bIsAudioMuteEnabled(unsigned char u8AudioMute)
{
	//increment mute counter only when audiomute changes from 0 to 1.
	//When audiomute continues to be 1 keep mutecounter as it is.
	//When audiomute changes to 0 and comes back to 1, increment the mute counter.
	if((u8AudioMute == AUDIO_MUTED) && (u8AudioMute != u8PreviousAudioMuteValue))
	{
		u8PreviousAudioMuteValue = u8AudioMute;
		return true;
	}
	else
	{
		ETG_TRACE_USR4(("u8AudioMute = %d u8PreviousAudioMuteValue=%d", u8AudioMute, u8PreviousAudioMuteValue));
		u8PreviousAudioMuteValue = u8AudioMute;
		return false;
	}
}

