/************************************************************************
 * FILE:          clTmcTuner_Method_SetDemodulationSwitch.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_SetDemodulationSwitch.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/





#ifndef clTmcTuner_Method_SetDemodulationSwitch_h
#define clTmcTuner_Method_SetDemodulationSwitch_h


#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clServerMethod.h"


class clAars_DemodulationSwitch;
class clAars_ATPresetList_XX;
class tun_ActualData;


class clTmcTuner_Method_SetDemodulationSwitch : public tuner::CcaApp::clServerMethod
{
   public:    
      clTmcTuner_Method_SetDemodulationSwitch( tuner::CcaApp::clCCAhandler* poCCAhandler, \
		  clAars_DemodulationSwitch* poDemodulationSwitch,tun_ActualData* po_tun_ActualData,\
		  clAars_ATPresetList_XX* poATPresetList_XX);
      virtual ~clTmcTuner_Method_SetDemodulationSwitch();      
	  tVoid vSendSetDemodulationSwitchMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType oResStatus);

   //protected:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
   private:
      tVoid vSendDemodulationRequestToAars();
	  tVoid vGetCurrentActivePresetlist();


      clAars_DemodulationSwitch* m_poDemodulationSwitch;
	  tun_ActualData* m_potun_ActualData;
	  clAars_ATPresetList_XX* m_poATPresetList_XX;
      midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart m_oMessage;
};


#endif

