/************************************************************************
 * FILE:         clTmcTuner_Method_S_USER_PROFILE_UPDATE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_USER_PROFILE_UPDATE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author      aso9kor                 | Modification


 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_USER_PROFILE_UPDATE.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "Aars/clAars_CM_SetUserOptions.h"
#include "Aars/clAars_CM_CopyUserContent.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "conversionTable/midwTunerToAdr3Map.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_USER_PROFILE_UPDATE.cpp.trc.h"
#endif

#define TUN_GUEST_USER_SETTINGS 0x2
#define TUN_CHANGE_PRESETS_LSM_FOR_USER 0x00
#define TUN_GUEST_USER 0x00
/**************************************************************************//**
*
******************************************************************************/

clTmcTuner_Method_S_USER_PROFILE_UPDATE::~clTmcTuner_Method_S_USER_PROFILE_UPDATE()
{
	m_poATPresetList_XX=0;
	m_poSetUserOptions = 0;
	m_poCopyUserContent = 0;
	m_u16RegisterID = 0;
	m_u16CmdCounter = 0;
	m_u16DestAppID = 0;
	m_u16ActivePresetList = 0xFF;
	m_bDeleteRequestSent= false;
	m_bProfileChangeRequestSent=false;
	m_bProfileCopyRequestSent=false;
	m_potun_MsgToADR = NULL;
}

/**************************************************************************//**
*
******************************************************************************/

clTmcTuner_Method_S_USER_PROFILE_UPDATE::clTmcTuner_Method_S_USER_PROFILE_UPDATE( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_SetUserOptions* poSetUserOptions,clAars_CM_CopyUserContent* poCopyUserContent, clAars_ATPresetList_XX* poATPresetList_XX)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE, poCCAhandler)
,m_poATPresetList_XX(poATPresetList_XX)
,m_poSetUserOptions(poSetUserOptions)
,m_poCopyUserContent(poCopyUserContent)
,m_u16RegisterID(AMT_C_U16_REGID_INVALID)
,m_u16CmdCounter(0)
,m_u16DestAppID(0)
,m_u16ActivePresetList(0xFF)
,m_bDeleteRequestSent(false)
,m_bProfileChangeRequestSent(false)
,m_bProfileCopyRequestSent(false)
{
	m_potun_MsgToADR = NULL;
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vMethodStart(amt_tclServiceData* poInMsg)
{
	if(poInMsg == NULL || m_poSetUserOptions == NULL || m_poCopyUserContent == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vMethodStart , null pointer"));
		return;
	}
    ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart m_oMessage;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    m_u16RegisterID = poInMsg->u16GetRegisterID();
    m_u16CmdCounter = poInMsg->u16GetCmdCounter();
    m_u16DestAppID = poInMsg->u16GetSourceAppID();

    switch(m_oMessage.Action.enType)
    {
    case midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_CHANGE:
    {
    	if(m_poSetUserOptions->u8GetCurrentUserID() == m_oMessage.UserID)
    	{
    	    ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: MethodStart Same User No update required"));
    		midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
    		oResult.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_CHANGE;
    		oResult.ActiveUserID = m_poSetUserOptions->u8GetCurrentUserID();
    		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
    		vSendMessage(m_u16DestAppID,
    					oResult,
    					MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
    					AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
    					m_u16CmdCounter,
    					m_u16RegisterID);
    	}
    	else
    	{
    		m_bProfileChangeRequestSent = true;
			tU32 u32UserOptions = TUN_CHANGE_PRESETS_LSM_FOR_USER;
			if(m_oMessage.UserID == TUN_GUEST_USER)
			{
				u32UserOptions = TUN_GUEST_USER_SETTINGS;
			}
			m_poSetUserOptions->vSetUser(m_oMessage.UserID,u32UserOptions);
    	}
	    break;
    }
    case midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_DELETE:
    {
    	m_bDeleteRequestSent = true;
    	ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vMethodStart Delete requested"));
    	if(m_potun_MsgToADR != NULL)
    	{
			/*User option setting changed to fix bug NCG3D-80489
			 10+ (n-1)	Reset all presets and TP and demodulation settings of user id (n-1) to the original values*/
       		m_potun_MsgToADR->vSendDefaultSetting((tU8)(10 + m_oMessage.UserID));
    	}
    	break;
    }
    case midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_COPY:
    {
    	m_bProfileCopyRequestSent = true;
    	m_poCopyUserContent->vCopyUser(m_oMessage.DestinationUserID);
    	break;
    }
	default:
	{
		midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
		break;
	}
    }
}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnNewCMSetUserOptionsStatus(unsigned char u8UserId, unsigned int /*u32UserOptions*/)
{
	if(m_poATPresetList_XX == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vOnNewCMSetUserOptionsStatus , null pointer"));
		return;
	}
	ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vOnNewCMSetUserOptionsStatus"));
	ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vOnNewCMSetUserOptionsStatus: m_u16ActivePresetList : %d", m_u16ActivePresetList));

	if(true == m_bProfileChangeRequestSent)
	{
	midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
	oResult.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_CHANGE;
	oResult.ActiveUserID = u8UserId;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	vSendMessage(m_u16DestAppID,
				oResult,
				MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
				AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				m_u16CmdCounter,
				m_u16RegisterID);
		m_bProfileChangeRequestSent = false;
		if(m_u16ActivePresetList != 0xFF)
		{
			m_poATPresetList_XX->vGetPresetList(m_u16ActivePresetList);
		}

		if (NULL != m_potun_MsgToADR)
		{
			m_potun_MsgToADR->vSendGetAnnouncementSwitch();
			m_potun_MsgToADR->vGetREGMode();
		}
	}

}

/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnCM_SetUserOptionsError(clCMError &oData)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnCM_SetUserOptionsError(), ErrorCode:%d ,ErrorInfo: %d, ", oData.getErrorCode(), oData.getErrorInfo()));
	if (true == m_bProfileChangeRequestSent)
	{
	midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	vSendMessage(m_u16DestAppID,
				oResult,
				MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
				AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				m_u16CmdCounter,
				m_u16RegisterID);
		m_bProfileChangeRequestSent = false;
}

}


tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnCopyUserContentResult()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vOnCopyUserContentResult"));
	if(true == m_bProfileCopyRequestSent)
	{
	midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
	oResult.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_COPY;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	vSendMessage(m_u16DestAppID,
				oResult,
				MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
				AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				m_u16CmdCounter,
				m_u16RegisterID);
		m_bProfileCopyRequestSent = false;
}

}
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vSetActivePresetList(tU16 u16ActivePresetList)
{
	m_u16ActivePresetList = u16ActivePresetList;
}
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnCM_CopyUserContentError(clCMError &oData)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnCM_CopyUserContentError(), ErrorCode:%d ,ErrorInfo: %d, ", oData.getErrorCode(), oData.getErrorInfo()));
	if(true == m_bProfileCopyRequestSent)
	{
	midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	vSendMessage(m_u16DestAppID,
				oResult,
				MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
				AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				m_u16CmdCounter,
				m_u16RegisterID);
		m_bProfileCopyRequestSent = false;
	}

}
tVoid clTmcTuner_Method_S_USER_PROFILE_UPDATE::vOnDeleteProfileResult(tBool bStatus)
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: vOnDeleteProfileResult m_bDeleteRequestSent = %d bStatus= %d  ", m_bDeleteRequestSent ,bStatus));
	if(m_bDeleteRequestSent)
	{
	midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oResult;
	oResult.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_DELETE;
	if(true == bStatus )
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	else
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;


		vSendMessage(m_u16DestAppID,
				oResult,
				MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE,
				AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,
				m_u16CmdCounter,
				m_u16RegisterID);
		m_bDeleteRequestSent = false;
		if (NULL != m_potun_MsgToADR)
		{
			m_potun_MsgToADR->vSendGetAnnouncementSwitch();
			m_potun_MsgToADR->vGetREGMode();
		}
	}
}
void clTmcTuner_Method_S_USER_PROFILE_UPDATE::vSet_tun_MsgToADR_Ptr(tun_MsgToADR* potun_MsgToADR)
{
	if(potun_MsgToADR != NULL)
	{
		m_potun_MsgToADR = potun_MsgToADR;
	}
}
