/************************************************************************
 * FILE:          clTmcTuner_Method_S_TEST_MODE.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_TEST_MODE.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/



#ifndef clTmcTuner_Method_S_Test_Mode_h
#define clTmcTuner_Method_S_Test_Mode_h


#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clServerMethod.h"


class clAars_EnhancedTestMode;
class clAars_HDTestMode;

#ifdef VARIANT_S_FTR_ENABLE_DRM
class clAars_DRMTestMode;
#endif


class clTmcTuner_Method_TestMode : public tuner::CcaApp::clServerMethod
{
   public:
#ifdef VARIANT_S_FTR_ENABLE_DRM
    clTmcTuner_Method_TestMode( tuner::CcaApp::clCCAhandler* poCCAhandler, \
		clAars_EnhancedTestMode* poEnhancedTestMode, \
		clAars_HDTestMode* poclAars_HDTestMode, clAars_DRMTestMode* poclAars_DRMTestMode);
#else
	clTmcTuner_Method_TestMode( tuner::CcaApp::clCCAhandler* poCCAhandler, \
		clAars_EnhancedTestMode* poEnhancedTestMode, \
		clAars_HDTestMode* poclAars_HDTestMode);
#endif
    virtual ~clTmcTuner_Method_TestMode();

    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
   private:
    tVoid vSendTestModeRequestToAars();

    clAars_EnhancedTestMode* m_poEnhancedTestMode;
	clAars_HDTestMode* m_poclAars_HDTestMode;
#ifdef VARIANT_S_FTR_ENABLE_DRM
	clAars_DRMTestMode* m_poclAars_DRMTestMode;
#endif
    midw_tunerfi_tclMsgFID_TUN_S_SET_TESTMODEMethodStart m_oMessage;
};


#endif //  clTmcTuner_Method_S_Test_Mode_h
