/************************************************************************
 * FILE:           clTmcTuner_Method_S_Set_AF.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_Set_AF.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   Oct 8, 2015		  pmn3kor
 *************************************************************************/



#include "AMFMTuner/clTmcTuner_Method_S_Set_AF.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_AFBestSwitch.h"
#include "tun_MsgToHMI.h"

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_Set_AF.cpp.trc.h"
#endif

#define EnableFirstBit 1
#define EnableThirdBit 4
using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_Set_AF::~clTmcTuner_Method_S_Set_AF()
{
   m_poAFBestSwitch = NULL;
   m_potun_MsgToHMI = NULL;
}


/******************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_Set_AF::clTmcTuner_Method_S_Set_AF(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_AFBestSwitch* poAFBestSwitch, tun_MsgToHMI* potun_MsgToHMI)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_AF, poCCAhandler)
     ,m_poAFBestSwitch(poAFBestSwitch),
     m_potun_MsgToHMI(potun_MsgToHMI)
{

}

/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_S_Set_AF::vMethodStart(amt_tclServiceData* poInMessage )
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_Set_AF: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);
   vSendAFBestSwitchRequestToAars();
   midw_tunerfi_tclMsgFID_TUN_S_SET_AFMethodResult oResult;
   vSendMethodResult(oResult);
}

/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_S_Set_AF::vSendAFBestSwitchRequestToAars()
{
   if(m_potun_MsgToHMI == NULL)
   {
      NORMAL_M_ASSERT(m_potun_MsgToHMI != NULL);
      return;
   }

   unsigned char u8Mask1 = (m_oMessage.b8AFSwitchMask.u8Value) & EnableFirstBit;
   unsigned char u8Mask2 = (m_oMessage.b8AFSwitchMask.u8Value) & EnableThirdBit;

   unsigned char u8CurrentAFSwitchValue = m_potun_MsgToHMI->u8GetAFSwitchValue();
   ETG_TRACE_USR4(("vSendAFBestSwitchRequestToAars previous value AF = %d", u8CurrentAFSwitchValue));
   ETG_TRACE_USR4(("m_oMessage.b8AFSwitchMask.u8Value = %d", m_oMessage.b8AFSwitchMask.u8Value));
   ETG_TRACE_USR4(("m_oMessage.b8AFSwitch.u8Value = %d", m_oMessage.b8AFSwitch.u8Value));

   if( u8Mask1 )
   {
      u8CurrentAFSwitchValue = (unsigned char)( ( u8Mask1 & m_oMessage.b8AFSwitch.u8Value)?\
            ( u8CurrentAFSwitchValue | u8Mask1 ) :
            ( u8CurrentAFSwitchValue & ~ u8Mask1));
      ETG_TRACE_USR4((" Inside u8Mask1: u8CurrentAFSwitchValue = %d", u8CurrentAFSwitchValue));
   }
   if( u8Mask2 )
   {
      u8CurrentAFSwitchValue = (unsigned char)(( u8Mask2 & m_oMessage.b8AFSwitch.u8Value)?\
                  ( u8CurrentAFSwitchValue | u8Mask2) :
                  ( u8CurrentAFSwitchValue & ~ u8Mask2));
      ETG_TRACE_USR4(("Inside  u8Mask2 : u8CurrentAFSwitchValue = %d", u8CurrentAFSwitchValue));
   }
   
   ETG_TRACE_USR4(("vSendAFBestSwitchRequestToAars  updated value AF = %d", u8CurrentAFSwitchValue));
   m_poAFBestSwitch->vSetAFBestSwitch(u8CurrentAFSwitchValue);

}


