/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_PI.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SET_PI.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#ifndef clTmcTuner_Method_S_SET_PI_NEW_h
#define clTmcTuner_Method_S_SET_PI_NEW_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/clMuteInterface.h"

class clAars_ATPI;

class clSetPIMuteData
{
public:
	clSetPIMuteData();
    virtual ~clSetPIMuteData() {}
    unsigned char m_u8AbsOrRel;
    unsigned char m_u8RelSteps;
    unsigned char m_u8Direction;
    unsigned char m_u8Nsteps;
    unsigned short m_u16PI;
    unsigned int m_u32Frequency;
};

class clTmcTuner_Method_S_SET_PI : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface, public Mute::clMuteInterface
{
public:
    virtual ~clTmcTuner_Method_S_SET_PI();
    clTmcTuner_Method_S_SET_PI( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPI* poATPI);
    tVoid vConstructSelfPostMessage(unsigned char* puchData);

private:
    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);

    clAars_ATPI* m_poATPI;
    clSetPIMuteData m_oMuteData;
    midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart m_oMessage;
    void vStorePIData();
    virtual void vProcessTunerAction();
    virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction);
    virtual void vOnAudioMuteRequest();
    virtual void vOnDemuteSendMethodResult();
    virtual void vOnTunerStateIdle();
	virtual void vClearStoredRequest();
    tBool bIsRelativeModeIncrement();
    tBool bIsSelectModeRelative();
    tBool bIsValidParameter();
    tBool bIsValidData();
};



#endif /* clTmcTuner_Method_S_SET_PI_NEW_h */
