/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_SET_PI.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATPI.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SET_PI.cpp.trc.h"
#endif

clTmcTuner_Method_S_SET_PI::~clTmcTuner_Method_S_SET_PI()
{
	m_poATPI = NULL;
}
clTmcTuner_Method_S_SET_PI::clTmcTuner_Method_S_SET_PI( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPI* poATPI)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI, poCCAhandler)
, m_poATPI(poATPI)
{

}

tVoid clTmcTuner_Method_S_SET_PI::vMethodStart(amt_tclServiceData* poInMsg)
{

    ETG_TRACE_USR4(("clTmcTuner_Method_S_SET_PI: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult oResult;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    if(bIsValidParameter())
    {
        vStorePIData();
        vOnNewMuteTunerAction(Mute::MuteHandling::ATPI);
        oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
    }
    else
    {
        oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
     }
	 
	 vSendMethodResult(oResult);
 }

void clTmcTuner_Method_S_SET_PI::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::vOnNewMuteTunerAction()"));
    clMuteImpl::instance()->vOnNewMuteTunerAction(muteAction);
}


void clTmcTuner_Method_S_SET_PI::vStorePIData()
{
    m_oMuteData.m_u8AbsOrRel = m_oMessage.TunSetPIPara.u8AbsOrRel.enType;
    m_oMuteData.m_u8RelSteps = m_oMessage.TunSetPIPara.u8RelSteps.enType;
    m_oMuteData.m_u8Direction = m_oMessage.TunSetPIPara.u8Direction.enType;
    m_oMuteData.m_u8Nsteps = m_oMessage.TunSetPIPara.u8Nsteps;
    m_oMuteData.m_u16PI = m_oMessage.TunSetPIPara.u16PI;
    m_oMuteData.m_u32Frequency = m_oMessage.TunSetPIPara.u32Frequency;
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::vStorePIData(): m_u8Nsteps = %d, m_u16PI = 0x%x, m_u32Frequency = %d", m_oMuteData.m_u8Nsteps, m_oMuteData.m_u16PI, m_oMuteData.m_u32Frequency));
}
void clTmcTuner_Method_S_SET_PI::vProcessTunerAction()
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::vProcessTunerAction()"));
    	if(bIsValidData())
    	{
    		if(bIsSelectModeRelative())
    		{
    			if(bIsRelativeModeIncrement())
    			{
    				m_poATPI->vIncrementStep(m_oMuteData.m_u8Nsteps);
    			}
    			else
    			{
    				m_poATPI->vDecrementStep(m_oMuteData.m_u8Nsteps);
    			}
    		}
    		else
    		{
    			m_poATPI->vSelectPIFrequency(m_oMuteData.m_u16PI,  m_oMuteData.m_u32Frequency);
    		}
    		vClearStoredRequest();
    	}
}
void clTmcTuner_Method_S_SET_PI::vOnAudioMuteRequest()
{

}
void clTmcTuner_Method_S_SET_PI::vOnDemuteSendMethodResult()
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::vProcessTunerAction(): When mute is disabled"));
    midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult oResult;
    oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
    oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

    vSendMethodResult(oResult);
}
void clTmcTuner_Method_S_SET_PI::vOnTunerStateIdle()
{

}
/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Method_S_SET_PI::bIsValidParameter()
{
    tBool bResult = false;
    if(m_oMessage.TunSetPIPara.u8AbsOrRel.enType == midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_TUN_PI_ABS)
    {
		bResult = true;
	}
	else if(m_oMessage.TunSetPIPara.u8AbsOrRel.enType == midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_TUN_PI_REL )
	{
		if(m_oMessage.TunSetPIPara.u8Direction.enType == midw_fi_tcl_e8_Tun_Direction::FI_EN_TUN_PI_DIR_UP || m_oMessage.TunSetPIPara.u8Direction.enType == midw_fi_tcl_e8_Tun_Direction::FI_EN_TUN_PI_DIR_DOWN)
		{
			bResult = true;
		}
	}
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::bIsValidParameter(): bResult = %d",bResult));
    return bResult;
}

/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Method_S_SET_PI::bIsRelativeModeIncrement()
{
    if(m_oMuteData.m_u8Direction == midw_fi_tcl_e8_Tun_Direction::FI_EN_TUN_PI_DIR_UP)
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**************************************************************************//**
*
******************************************************************************/
tBool clTmcTuner_Method_S_SET_PI::bIsSelectModeRelative()
{
    if(m_oMuteData.m_u8AbsOrRel == midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_TUN_PI_REL)
    {
        return true;
    }
    else
    {
        return false;
    }
}

clSetPIMuteData::clSetPIMuteData()
{
	m_u8AbsOrRel = midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_INVALID_TYPE;
	m_u8RelSteps = 0;
	m_u8Direction = midw_fi_tcl_e8_Tun_Direction::FI_EN_INVALID_TYPE;
	m_u8Nsteps = 0;
	m_u16PI = 0;
	m_u32Frequency = 0;
}

void clTmcTuner_Method_S_SET_PI::vClearStoredRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_SET_PI::vClearStoredRequest()"));
	m_oMuteData.m_u8AbsOrRel = midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_INVALID_TYPE;
	m_oMuteData.m_u8RelSteps = 0;
	m_oMuteData.m_u8Direction = midw_fi_tcl_e8_Tun_Direction::FI_EN_INVALID_TYPE;
	m_oMuteData.m_u8Nsteps = 0;
	m_oMuteData.m_u16PI = 0;
	m_oMuteData.m_u32Frequency = 0;
}

tVoid clTmcTuner_Method_S_SET_PI::vConstructSelfPostMessage(unsigned char* puchData)
{
    midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart oMsg;
    tU32 u32Frequency = 0x00;
    tU16 u16PI = 0x00;

    oMsg.TunSetPIPara.u8AbsOrRel.enType = (midw_fi_tcl_e8_Tun_Abs_Or_Rel::tenType)puchData[1];
    oMsg.TunSetPIPara.u8RelSteps.enType = (midw_fi_tcl_e8_Tun_Rel_Steps::tenType)0;
    oMsg.TunSetPIPara.u8Direction.enType = (midw_fi_tcl_e8_Tun_Direction::tenType)puchData[2];

    oMsg.TunSetPIPara.u8Nsteps = puchData[3];
    u16PI |= ( tU16 ) ( ( (tU16)  puchData[4]  ) << 8  ) ;
    u16PI =  ( tU16 )(u16PI |(( (tU16) puchData[5] )));
    oMsg.TunSetPIPara.u16PI = u16PI;
    u32Frequency  = ( tU32 ) ( ( (tU32)  puchData[6]  ) << 24 ) ;
    u32Frequency |= ( tU32 ) ( ( (tU32)  puchData[7]  ) << 16 ) ;
    u32Frequency |= ( tU32 ) ( ( (tU32)  puchData[8]  ) << 8  ) ;
    u32Frequency |= ( tU32 ) (   (tU32)  puchData[9]  );
    oMsg.TunSetPIPara.u32Frequency = u32Frequency;

    vSendMessage(CCA_C_U16_APP_TUNER, oMsg, MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, 0, 0);
}
tBool clTmcTuner_Method_S_SET_PI::bIsValidData()
{
	if((m_oMuteData.m_u8AbsOrRel == midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_INVALID_TYPE) &&
	(m_oMuteData.m_u8RelSteps == 0) &&
	(m_oMuteData.m_u8Direction == midw_fi_tcl_e8_Tun_Direction::FI_EN_INVALID_TYPE) &&
	(m_oMuteData.m_u8Nsteps == 0) &&
	(m_oMuteData.m_u16PI == 0) &&
	(m_oMuteData.m_u32Frequency == 0))
	{
		return false;
	}
	else
	{
		return true;
	}
}

