/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_EvaluationParameter.h"

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER::~clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER()
{
	m_poEvaluationParameter = 0;

}


/******************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER::clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER(clCCAhandler* poCCAhandler, clAars_CM_EvaluationParameter* poEvaluationParameter)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_HD_SECTION_PARAMETER, poCCAhandler)
     ,m_poEvaluationParameter(poEvaluationParameter)
{

}


/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER::vMethodStart(amt_tclServiceData* poInMessage )
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

    vSendHDSectionParameterRequestToAars();
    midw_tunerfi_tclMsgFID_TUN_S_SET_HD_SECTION_PARAMETERMethodResult oResult;
    vSendMethodResult(oResult);
}


tVoid clTmcTuner_Method_S_SET_HD_SECTION_PARAMETER::vSendHDSectionParameterRequestToAars()
{
   m_poEvaluationParameter->vSetHDSectionParameter(m_oMessage.e16Parameter_ID.enType,m_oMessage.s8ParameterValue);
}


