/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
  
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_EvaluationParameter.h"

#include "tuner_trace.h"

#define AUDIO_SPLIT_MODE_ID 0
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE.cpp.trc.h"
#endif

using namespace tuner::CcaApp;

/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE::~clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE()
{
	m_poEvaluationParameter = 0;

}


/******************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE::clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE(clCCAhandler* poCCAhandler, clAars_CM_EvaluationParameter* poEvaluationParameter)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_AUDIO_SPLIT_MODE, poCCAhandler)
     ,m_poEvaluationParameter(poEvaluationParameter)
{

}


/*****************************************************************************
*
******************************************************************************/
tVoid clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE::vMethodStart(amt_tclServiceData* poInMessage )
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);

    vSendAudioSplitModeRequestToAars();
    midw_tunerfi_tclMsgFID_TUN_S_SET_AUDIO_SPLIT_MODEMethodResult oResult;
    vSendMethodResult(oResult);
}


tVoid clTmcTuner_Method_S_SET_AUDIO_SPLIT_MODE::vSendAudioSplitModeRequestToAars()
{
	m_poEvaluationParameter->vSetHDSectionParameter(AUDIO_SPLIT_MODE_ID,m_oMessage.e8ParameterValue.enType);
}


