/************************************************************************
 * FILE:           clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.cpp method class implementation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "Aars/clAars_ATPresetListSetActive.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tun_ActualData.h"
#include "tun_MsgToHMI.h"
#include "kdsconfig/clConfigInterface.h"
#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGFROMHMI
#include "trcGenProj/Header/clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST.cpp.trc.h"
#endif

#include "ADRMsg/ADRMsgDefines.h"
#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#endif
using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::~clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST()
{
	m_poATPresetListSetActive=NULL;
	m_poATPresetList_XX=NULL;
	m_potun_ActualData=NULL;
	m_potun_MsgToHMI=0;
	m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID = NULL;
	m_poclConfigInterface = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST(clCCAhandler* poCCAhandler, clAars_ATPresetListSetActive* poATPresetListSetActive,
		tun_ActualData* potun_ActualData,clAars_ATPresetList_XX* poATPresetList_XX, tun_MsgToHMI* potun_MsgToHMI, clConfigInterface*  poclConfigInterface )
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SET_ACTIVE_PRESETLIST, poCCAhandler),
   m_poATPresetListSetActive(poATPresetListSetActive),
   m_potun_ActualData(potun_ActualData),
   m_poATPresetList_XX(poATPresetList_XX),
   m_potun_MsgToHMI(potun_MsgToHMI),
   m_poclConfigInterface(poclConfigInterface)
{
	m_bSetActivePresetListRequested=false;
	m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID = NULL;
	m_U16ADR3PresetListIDForSetActivePresetList=enMsg_Unknown_Message_0x0000;
   dp_tclTmcTunerDPPresetListID  oPresetListID;
   m_U16ADR3PresetListIDForSetActivePresetList = oPresetListID.tGetData();
   ETG_TRACE_USR4(("clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST() -->PresetListIC=%02x",m_U16ADR3PresetListIDForSetActivePresetList));
}

/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vSet_G_GET_ACTIVE_PRESETLISTID_Ptr( clTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID*  poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID )
{
	if(poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID != NULL)
	{
		m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID = poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID;
	}
}


/**************************************************************************//**
* vMethodStart
******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vMethodStart(amt_tclServiceData* poInMessage)
{
   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodStart oMessage; 
   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
   unsigned short U16ADR3PresetListID = U16GetADR3PresetListID(oMessage.e8ListID.enType);
   vSaveListIDForSetActivePresetList(U16ADR3PresetListID);
	if(bIsPresetListMatchesCurrentBand(oMessage.e8ListID.enType))
	{	
		m_poATPresetListSetActive->vSendATPresetListSetActive(U16ADR3PresetListID);
	}
	else
	{
		vSetActivePresetListRequested(true);
		midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_ACCEPTED_INPROGRESS;
		vSendMethodResult(oResult);
	}
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vSaveListIDForSetActivePresetList(unsigned short U16ADR3PresetListID )
{
	if((m_potun_MsgToHMI == NULL) || (m_poclConfigInterface == NULL))
	{
		return;
	}
	tU8 u8Tunerband = oGetADR3ToMidwTunerBand(U16ADR3PresetListID);
	if(u8Tunerband == tuner::common::BANDFM)
	{
		m_potun_MsgToHMI->vSetFMActivePresetListId(U16ADR3PresetListID);
	}
	if(u8Tunerband == tuner::common::BANDMW)
	{
		m_potun_MsgToHMI->vSetAMActivePresetListId(U16ADR3PresetListID);
	}
	if((u8Tunerband == tuner::common::BANDCB1) && (m_poclConfigInterface->u32GetConfigData("DRMSupported")))
	{

		m_potun_MsgToHMI->vSetDRMActivePresetListId(U16ADR3PresetListID);
	}
	m_U16ADR3PresetListIDForSetActivePresetList=U16ADR3PresetListID;
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vSetActivePresetListRequested(bool bSetState)
{
	m_bSetActivePresetListRequested=bSetState;
}
/*****************************************************************************

******************************************************************************/
bool clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::bIsActivePresetListRequested()
{
	return m_bSetActivePresetListRequested;
}
/*****************************************************************************

******************************************************************************/
bool clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::bIsPresetListMatchesCurrentBand(unsigned short u16List)
{
	unsigned char u8TunerBand = U8GetTunerBand((midw_fi_tcl_e8_Tun_ListID::tenType)u16List);
	unsigned char u8Band=m_potun_ActualData->m_otun_Data_Station.u8GetBand();
	if((u8TunerBand==u8Band) ||(tuner::common::BANDNONE==u8TunerBand))
	{
		return true;
	}
	else
	{
        return false;
	}
}
/*****************************************************************************

******************************************************************************/
unsigned short clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::U16GetADR3PresetListIDForSetActivePresetList()
{
	return m_U16ADR3PresetListIDForSetActivePresetList;
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vOnATPresetListSetActiveResult()
{
	   unsigned short U16ADR3PresetListID=U16GetADR3PresetListIDForSetActivePresetList();
	   if(ADR_MSG_FID_INVALID!=U16ADR3PresetListID )
	   {
		  vStoreActivePresetList(U16ADR3PresetListID);
		  if(m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID != NULL)
		  {
			  m_poclTmcTuner_Property_G_GET_ACTIVE_PRESETLISTID->vSendActivePresetListID();
		  }
	 	  m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
	   }
	   midw_tunerfi_tclMsgFID_TUN_S_SET_ACTIVE_PRESETLISTMethodResult oResult;
	   oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	   oResult.TunerServer_StatusResponse.u8TunerState.enType =midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;
	   vSendMethodResult(oResult);
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SET_ACTIVE_PRESETLIST::vStoreActivePresetList(unsigned short U16ADR3PresetListID)
{
	dp_tclTmcTunerDPPresetListID oPresetListID;
	oPresetListID.vSetData(U16ADR3PresetListID);

	tU8 u8Tunerband = oGetADR3ToMidwTunerBand(U16ADR3PresetListID);
	if(u8Tunerband == tuner::common::BANDFM)
	{
		m_potun_MsgToHMI->vSetFMActivePresetListId(U16ADR3PresetListID);
	}
	if(u8Tunerband == tuner::common::BANDMW)
	{
		m_potun_MsgToHMI->vSetAMActivePresetListId(U16ADR3PresetListID);
	}
	if(u8Tunerband == tuner::common::BANDCB1)
	{
		m_potun_MsgToHMI->vSetDRMActivePresetListId(U16ADR3PresetListID);
	}
}

