/************************************************************************
 * FILE:           clTmcTuner_Method_S_SEL_LIST_ELEM.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SEL_LIST_ELEM.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/

#ifndef clTmcTuner_Method_S_SEL_LIST_ELEM_h
#define clTmcTuner_Method_S_SEL_LIST_ELEM_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/clMuteInterface.h"
#include "tun_ActualData.h"
#include "Aars/clAars_CM_StationsList.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"
#include "clTmcTuner_Method_S_STATIONLIST_EXIT.h"
#include "clTmcTuner_Method_S_GET_CONFIG_LIST.h"
#ifndef TUN_MsgToADR_H
#include "tun_MsgToADR.h"
#endif

namespace Mute
{
	namespace MuteHandling
	{
		class clMuteImpl;
	}
}

class clConfigInterface;

class clStationListMuteData
{
public:
	virtual ~clStationListMuteData() {}
	unsigned char  m_u8ListElementID;
	unsigned char  m_u8ConfigListID;
	unsigned short m_u16PICode;
	unsigned int   m_u32Frequency;
	unsigned short m_u32HDStnID_DRMSrvID;
	clCMEnum_ModulationType eModulationType;
	clStationListMuteData();
};

class clTmcTuner_Method_S_SEL_LIST_ELEM : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface, public Mute::clMuteInterface
{
   public:
      virtual ~clTmcTuner_Method_S_SEL_LIST_ELEM();
      clTmcTuner_Method_S_SEL_LIST_ELEM( tuner::CcaApp::clCCAhandler* poCCAhandler, clConfigInterface* poclConfigInterface,
    		  tun_ActualData* poActualData, clAars_CM_StationsList* poStationsList
    		  ,clTmcTuner_Method_S_STATIONLIST_EXIT* poclTmcTuner_Method_S_STATIONLIST_EXIT 
			  ,clTmcTuner_Method_S_GET_CONFIG_LIST* poclTmcTuner_Method_S_GET_CONFIG_LIST,tun_MsgToADR* potun_MsgToADR);
	  clCMEnum_Band u8GetBandFromFrequency();
	  virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
	  virtual void vProcessTunerAction();
	  virtual void vOnAudioMuteRequest();
	  virtual void vOnDemuteSendMethodResult();
	  virtual void vOnTunerStateIdle();
	  virtual void vClearStoredRequest();
	  clCMEnum_Band u8GetBandFromStationListID();
	  void setConfigListType(midw_fi_tcl_e8_Tun_ConfigListID::tenType ConfigListType);
	  bool bIsValidData();


   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
	  void vPerformExitRequest();
      midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart m_oMessage;
      clConfigInterface*      m_poclConfigInterface;
	  tun_ActualData*         m_poActualData;
	  tun_MsgToADR*           m_potun_MsgToADR;
	  clAars_CM_StationsList* m_poStationsList;
	  clStationListMuteData   m_oMuteData;
	  Mute::MuteHandling::clMuteImpl* m_poMuteImpl;
	  clTmcTuner_Method_S_STATIONLIST_EXIT* m_poclTmcTuner_Method_S_STATIONLIST_EXIT;
	  clTmcTuner_Method_S_GET_CONFIG_LIST* m_poclTmcTuner_Method_S_GET_CONFIG_LIST;
};


#endif
