/************************************************************************
 * FILE:           clTmcTuner_Method_S_SEL_LIST_ELEM.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SEL_LIST_ELEM.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "clTmcTuner_Method_S_SEL_LIST_ELEM.h"
#include "CcaApp/clCCAhandler.h"
#include "ADRMsg/ADRMsg_if.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"
#include "kdsconfig/clConfigInterface.h"

using namespace tuner::CcaApp;
using namespace Mute;
using namespace Mute::MuteHandling;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SEL_LIST_ELEM.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_SEL_LIST_ELEM::~clTmcTuner_Method_S_SEL_LIST_ELEM()
{
	m_poclConfigInterface = 0;
	m_poActualData = 0;
	m_potun_MsgToADR = 0;
	m_poStationsList = 0;
	m_poMuteImpl = 0;
	m_poclTmcTuner_Method_S_STATIONLIST_EXIT = NULL;
	m_poclTmcTuner_Method_S_GET_CONFIG_LIST = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_SEL_LIST_ELEM::clTmcTuner_Method_S_SEL_LIST_ELEM(tuner::CcaApp::clCCAhandler* poCCAhandler, clConfigInterface* poclConfigInterface,
		tun_ActualData* poActualData, clAars_CM_StationsList* poStationsList
		,clTmcTuner_Method_S_STATIONLIST_EXIT* poclTmcTuner_Method_S_STATIONLIST_EXIT\
		,clTmcTuner_Method_S_GET_CONFIG_LIST* poclTmcTuner_Method_S_GET_CONFIG_LIST,tun_MsgToADR* potun_MsgToADR)
: clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_SEL_LIST_ELEM, poCCAhandler),
  m_poclConfigInterface(poclConfigInterface),
  m_poActualData(poActualData),
  m_potun_MsgToADR(potun_MsgToADR),
  m_poStationsList(poStationsList),
  m_poclTmcTuner_Method_S_STATIONLIST_EXIT(poclTmcTuner_Method_S_STATIONLIST_EXIT),
  m_poclTmcTuner_Method_S_GET_CONFIG_LIST(poclTmcTuner_Method_S_GET_CONFIG_LIST)
{
	m_poMuteImpl = clMuteImpl::instance();
}


/**************************************************************************//**
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_SEL_LIST_ELEM::vMethodStart(amt_tclServiceData* poInMessage)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_SEL_LIST_ELEM::vMethodStart()"));
	midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodStart oMessage;
	m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);

	m_oMuteData.m_u8ListElementID      = oMessage.Sel_List_Elem.u8ListElementID;
	m_oMuteData.m_u8ConfigListID       = U8GetADR3StationListID(oMessage.Sel_List_Elem.eConfigListID.enType);
	m_oMuteData.m_u16PICode            = oMessage.Sel_List_Elem.u16PICode;
	m_oMuteData.m_u32Frequency         = oMessage.Sel_List_Elem.u32Frequency;
	m_oMuteData.m_u32HDStnID_DRMSrvID  = (unsigned short )oMessage.Sel_List_Elem.u32HDStnID_DRMSrvID;
	tU8 u8ModulationType = (tU8)oMessage.Sel_List_Elem.e8ModulationType.enType;
	m_oMuteData.eModulationType.enType = static_cast<clCMEnum_ModulationType::enModulationType>(u8ModulationType);

	vOnNewMuteTunerAction(Mute::MuteHandling::STATIONLIST);
}

/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_SEL_LIST_ELEM::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_SEL_LIST_ELEM::vOnNewMuteTunerAction()"));
	m_poMuteImpl->vOnNewMuteTunerAction(muteAction);
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vOnAudioMuteRequest()
{

}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vProcessTunerAction()
{
	if(bIsValidData())
	{
	/** if stationlist list element from other band(not currently tuned) is selected
		then send set lsm msg instead of station list element select*/
	clCMEnum_Band RequestedBand = u8GetBandFromStationListID();

	ETG_TRACE_USR1(( " clTmcTuner_Method_S_SEL_LIST_ELEM ::vProcessTunerAction(), ListID=%d,"
			"u8ListElementID=%d,u32ListElementFrequency=%d,u8ListElementPICode=0x%02x,RequestedBand = %d",
			m_oMuteData.m_u8ConfigListID,
			m_oMuteData.m_u8ListElementID,
			m_oMuteData.m_u32Frequency,
			m_oMuteData.m_u16PICode,
			RequestedBand.enType
			));

	m_potun_MsgToADR -> vSendSelListElem((tU16)m_oMuteData.m_u8ConfigListID, m_oMuteData.m_u8ListElementID, midw_fi_tcl_e8_Tun_ListType::FI_EN_TUN_LIST_TYPE_CONFIG);
	}
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vOnDemuteSendMethodResult()
{
	midw_tunerfi_tclMsgFID_TUN_S_SEL_LIST_ELEMMethodResult oResult;

	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	vSendMethodResult(oResult);
}

clStationListMuteData::clStationListMuteData() :
		m_u8ListElementID(0),
		m_u8ConfigListID(0xff),
		m_u16PICode(0),
		m_u32Frequency(0),
		m_u32HDStnID_DRMSrvID(0)
{
}

clCMEnum_Band clTmcTuner_Method_S_SEL_LIST_ELEM::u8GetBandFromFrequency()
{
	clCMEnum_Band eCurrentBand;
	unsigned int u32Frequency = m_oMuteData.m_u32Frequency;

	if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighFM") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM") <= u32Frequency))
	{
		eCurrentBand.enType = clCMEnum_Band::FM;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighLW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW") <= u32Frequency))
	{
		eCurrentBand.enType = clCMEnum_Band::LW;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") <= u32Frequency))
	{
		eCurrentBand.enType = clCMEnum_Band::MW;
	}

	return eCurrentBand;
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::setConfigListType(midw_fi_tcl_e8_Tun_ConfigListID::tenType ConfigListType)
{
	m_oMuteData.m_u8ConfigListID = U8GetADR3StationListID(ConfigListType);
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vOnTunerStateIdle()
{
	vPerformExitRequest();
	vClearStoredRequest();
	vOnDemuteSendMethodResult();
}
clCMEnum_Band clTmcTuner_Method_S_SEL_LIST_ELEM::u8GetBandFromStationListID()
{
   clCMEnum_Band u8Band;
   u8Band.enType = clCMEnum_Band::GetCurrentBand;
   unsigned short u16StationList = m_oMuteData.m_u8ConfigListID;
   switch(u16StationList)
   {
   case enTUN_TUN_CONFIG_LIST_FM:
   {
      u8Band.enType = clCMEnum_Band::FM;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_MW:
   {
      u8Band.enType = clCMEnum_Band::MW;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_LW:
   {
      u8Band.enType = clCMEnum_Band::LW;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_DRM:
   {
      u8Band.enType = clCMEnum_Band::CB1;
      break;
   }
   case enTUN_TUN_CONFIG_LIST_AM:
   {
      u8Band = u8GetBandFromFrequency();
      break;
   }
   default:
   {
      ETG_TRACE_USR4(("tun_MsgFromHMI::u8GetBandFromStationList() invalid stationListID = %d", u16StationList));
      break;
   }
   }
   return u8Band;
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vClearStoredRequest()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_SEL_LIST_ELEM::vClearStoredRequest()"));
	vPerformExitRequest();
	m_oMuteData.m_u8ListElementID = 0;
	m_oMuteData.m_u8ConfigListID = 0xff;
	m_oMuteData.m_u16PICode = 0;
	m_oMuteData.m_u32Frequency = 0;
	m_oMuteData.m_u32HDStnID_DRMSrvID = 0;
}

bool clTmcTuner_Method_S_SEL_LIST_ELEM::bIsValidData()
{
	if((m_oMuteData.m_u8ListElementID == 0) &&
	(m_oMuteData.m_u8ConfigListID == 0xff) &&
	(m_oMuteData.m_u16PICode == 0) &&
	(m_oMuteData.m_u32Frequency == 0) &&
	(m_oMuteData.m_u32HDStnID_DRMSrvID == 0))
	{
		return false;
	}
	else
	{
		return true;
	}
}

void clTmcTuner_Method_S_SEL_LIST_ELEM::vPerformExitRequest()
{
	if((m_poclTmcTuner_Method_S_STATIONLIST_EXIT == NULL) || (m_poclTmcTuner_Method_S_GET_CONFIG_LIST == NULL))
	{
		return;
	}
	ETG_TRACE_USR4(("clTmcTuner_Method_S_SEL_LIST_ELEM::vPerformExitRequest() listId = %d", m_oMuteData.m_u8ConfigListID));
	if(m_poclTmcTuner_Method_S_STATIONLIST_EXIT->bIsStationListExitRequested((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID))
	{
		if(m_poclTmcTuner_Method_S_STATIONLIST_EXIT->bIsStationListExitRequired((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID))
		{
			m_poclTmcTuner_Method_S_STATIONLIST_EXIT->vSendStationListExit((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID);
			m_poclTmcTuner_Method_S_STATIONLIST_EXIT->vClearStationListExitRequested((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID);
		}
		else
		{
			m_poclTmcTuner_Method_S_STATIONLIST_EXIT->vDecrementNoOfStationlistExitRequests((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID);
			m_poclTmcTuner_Method_S_STATIONLIST_EXIT->vSetConfigListId((midw_fi_tcl_e8_Tun_ConfigListID::tenType)midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE);
		}
		m_poclTmcTuner_Method_S_GET_CONFIG_LIST->vDecreementOpenStationListsCount((midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_oMuteData.m_u8ConfigListID);
		setConfigListType(midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_INVALID_TYPE);		
	}
}