/************************************************************************
 * FILE:           clTmcTuner_Method_S_SEEK.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_SEEK.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_SEEK.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATSeek.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_SEEK.cpp.trc.h"
#endif

clTmcTuner_Method_S_SEEK::~clTmcTuner_Method_S_SEEK()
{
	m_poATSeek =  NULL;
}
clTmcTuner_Method_S_SEEK::clTmcTuner_Method_S_SEEK( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATSeek* poATSeek)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_ATSEEK_WITH_TUNERHEADER, poCCAhandler)
, m_poATSeek(poATSeek)
{

}

tVoid clTmcTuner_Method_S_SEEK::vMethodStart(amt_tclServiceData* poInMsg)
{
    ETG_TRACE_USR1(("CCR.STARTING.SEEK:MethodStart"));
    ETG_TRACE_USR4(("clTmcTuner_Method_S_SEEK: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_ATSEEK_WITH_TUNERHEADERMethodResult oResult;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    unsigned char u8SeekState = m_poATSeek->getSeekMode();
    ETG_TRACE_USR4(("clTmcTuner_Method_S_SEEK: u8SeekState = %d, u8TunerSeek = %d", u8SeekState, m_oMessage.u8TunerSeek.enType));
    //if(u8SeekState == midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF && m_oMessage.u8TunerSeek.enType == midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF)
    //{
    //    ETG_TRACE_USR4(("clTmcTuner_Method_S_SEEK: MethodStart: ADR's seek already off"));
    //}
    //else
    {
		vStoreMuteData(m_oMessage.u8TunerSeek, m_oMessage.u32Frequency);
        /* if either seek off or scan request comes, should not send mute request*/
        if((m_oMessage.u8TunerSeek.enType != (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_OFF) && (bIsTunScan() == false))
        {
			vOnNewMuteTunerAction(Mute::MuteHandling::SEEK);
        }
		else
		{
			/* if seek off or scan request comes, forward it to ADR*/
			vProcessTunerAction();
		}
    }
    vSendMethodResult(oResult);
 }

void clTmcTuner_Method_S_SEEK::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SEEK::vOnNewMuteTunerAction()"));
    clMuteImpl::instance()->vOnNewMuteTunerAction(muteAction);
}

void clTmcTuner_Method_S_SEEK::vProcessTunerAction()
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_SEEK::vProcessTunerAction: u8TunerSeek = %d, u32Frequency = %d", m_oMessage.u8TunerSeek.enType, m_oMessage.u32Frequency));
    if(m_oMuteData.bIsStoredDataValid())
    {
        m_poATSeek->vSendSeekStart(m_oMuteData.m_oSeekType.enType, m_oMuteData.m_u32Frequency);
        vClearStoredRequest();
    }
}

bool clSeekMuteData::bIsStoredDataValid()
{
    if(m_oSeekType.enType != midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_INVALID_TYPE)
    {
        return true;
    }
    return false;
}

void clTmcTuner_Method_S_SEEK::vOnAudioMuteRequest()
{

}
void clTmcTuner_Method_S_SEEK::vOnDemuteSendMethodResult()
{

}
void clTmcTuner_Method_S_SEEK::vOnTunerStateIdle()
{

}

bool clTmcTuner_Method_S_SEEK::bIsTunScan()
{
    if(m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_PI ||
        m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_FREQUENCY ||
        m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_UP_SCAN_PRESET ||
        m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PI ||
        m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_PRESET ||
        m_oMessage.u8TunerSeek.enType == (tU8)midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_TUN_SEEKTYPE_DOWN_SCAN_FREQUENCY)
    {
        return true;
    }
    return false;
}

clSeekMuteData::clSeekMuteData()
{
	m_oSeekType.enType = midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_INVALID_TYPE;
	m_u32Frequency = 0;
}

void clTmcTuner_Method_S_SEEK::vStoreMuteData(midw_fi_tcl_e8_Tun_TunerSeek oSeekType, unsigned int u32Frequency)
{
	m_oMuteData.m_oSeekType.enType = oSeekType.enType;
	m_oMuteData.m_u32Frequency = u32Frequency;
}

void clTmcTuner_Method_S_SEEK::vClearStoredRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_SEEK::vClearStoredRequest()"));
	m_oMuteData.m_oSeekType.enType = midw_fi_tcl_e8_Tun_TunerSeek::FI_EN_INVALID_TYPE;
	m_oMuteData.m_u32Frequency = 0;
}

