/************************************************************************
 * FILE:           clTmcTuner_Method_S_PRESET_HANDLING.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_PRESET_HANDLING.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	
 *************************************************************************/


#ifndef clTmcTuner_Method_S_PRESET_HANDLING_h
#define clTmcTuner_Method_S_PRESET_HANDLING_h


#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"
#include "TunerApp/Mute/clMuteInterface.h"
#ifndef TUN_MsgToADR_H
#include "tun_MsgToADR.h"
#endif

class clAars_ATPresetList_XX;
class clAars_ATPresetSave;

class clPresetRecallMuteData
{
public:
	virtual ~clPresetRecallMuteData() {}
	unsigned short m_u16PresetListID;
	unsigned char  m_u8PresetListElementID;
	clPresetRecallMuteData();
	bool bIsStoredDataValid();
};

class clTmcTuner_Method_S_PRESET_HANDLING : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface, public Mute::clMuteInterface
{
   public:
      virtual ~clTmcTuner_Method_S_PRESET_HANDLING();
      clTmcTuner_Method_S_PRESET_HANDLING( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetList_XX* poATPresetList_XX,clAars_ATPresetSave* poATPresetSave);
      void vRecallPreset(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID);
      void vPresetSave(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID);
      void vDeleteSinglePreset(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID);
	  void vDeleteAllPreset(unsigned short U16ADR3PresetListID);
	  void vPresetSpecialSave(unsigned short U16ADR3PresetListID,unsigned char u8ListElementID,unsigned short u16PI,unsigned int u32Frequency);
	  virtual void vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteTuningAction);
	  virtual void vProcessTunerAction();
	  virtual void vOnAudioMuteRequest();
	  virtual void vOnDemuteSendMethodResult();
	  virtual void vOnTunerStateIdle();
	  virtual void vClearStoredRequest();
	  tVoid vConstructSelfPostMessage(unsigned char* puchData);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);
	  void vStorePresetData(unsigned short u16PresetListID, unsigned char u8PresetListElemenetID);

      clAars_ATPresetList_XX* m_poATPresetList_XX;
      clAars_ATPresetSave* m_poATPresetSave;
      midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart m_oMessage;
	  clPresetRecallMuteData m_oMuteData;

};


#endif
