/*
 * clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE.cpp
 *
 *  Created on: 07-May-2018
 *      Author: aso9kor
 */

#include "AMFMTuner/clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "Aars/clAars_CM_PresetListContentUpdate.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "ADRMsg/ADRMsg_if.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "kdsconfig/clConfigInterface.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE.cpp.trc.h"
#endif

#define TYPE_OF_PARAMETER_SET 0
#define PRESETLIST_00 0x0f20

/**************************************************************************//**
*
******************************************************************************/
clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_PresetListContentUpdate* poclAars_CM_PresetListContentUpdate, clAars_ATPresetList_XX* poATPresetList_XX, clConfigInterface* poclConfigInterface)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_PRESETLIST_CONTENT_UPDATE, poCCAhandler),
 m_poclAars_CM_PresetListContentUpdate(poclAars_CM_PresetListContentUpdate),
 m_poATPresetList_XX(poATPresetList_XX),
 m_poclConfigInterface(poclConfigInterface),
 m_u16ActivePresetList(0xFF),
 m_bIsPresetListGetRequired(false)
{

}

clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::~clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE()
{
	m_poclAars_CM_PresetListContentUpdate = NULL;
	m_u16ActivePresetList = 0xFF;
	m_poATPresetList_XX = NULL;
	m_bIsPresetListGetRequired = false;
}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::vMethodStart(amt_tclServiceData* poInMsg)
{
	if(poInMsg == NULL || m_poclAars_CM_PresetListContentUpdate == NULL || m_poCCAhandler == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: vMethodStart , null pointer"));
		return;
	}
    ETG_TRACE_USR4(("clTmcTuner_Method_S_USER_PROFILE_UPDATE: MethodStart"));
	m_bIsPresetListGetRequired = false;
    midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart oMessage;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, oMessage);

    tU8 u8NumberOfPresetsToUpdate = (tU8)oMessage.Tun_ListElements.TunerListElement.size();

    std::vector<clCMPresetListContentUpdate_Data> oclCMPresetListContentUpdate_Data_list;
    for(tU8 i = 0; i < oMessage.Tun_ListElements.TunerListElement.size(); i++)
    {
        clCMPresetListContentUpdate_Data oclCMPresetListContentUpdate_Data;
    	vTrace(oMessage.Tun_ListElements.TunerListElement.at(i));

    	oclCMPresetListContentUpdate_Data.FktIdOfList	 = U16GetADR3PresetListID(oMessage.Tun_ListElements.TunerListElement.at(i).e8ListID.enType);
    	oclCMPresetListContentUpdate_Data.ElementID		 = oMessage.Tun_ListElements.TunerListElement.at(i).u8ElementID;
    	switch(oMessage.Tun_ListElements.TunerListElement.at(i).e8Modulation.enType)
    	{
    		case midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_ANALOG:
    			oclCMPresetListContentUpdate_Data.ModulationType.enType = clCMEnum_ModulationType::Analogue_AM_FM;
    			break;

    		case midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_DRM:
    			oclCMPresetListContentUpdate_Data.ModulationType.enType = clCMEnum_ModulationType::DRM;
    			break;

    		case midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_HD:
    			oclCMPresetListContentUpdate_Data.ModulationType.enType = clCMEnum_ModulationType::HD;
    			break;

    		default:
    			break;
    	}
    	oclCMPresetListContentUpdate_Data.Frequency		 = oMessage.Tun_ListElements.TunerListElement.at(i).u32Frequency;
    	oclCMPresetListContentUpdate_Data.SID			 = oMessage.Tun_ListElements.TunerListElement.at(i).u32SID;
    	if( NULL != oMessage.Tun_ListElements.TunerListElement.at(i).sStationName.szValue)
    		oclCMPresetListContentUpdate_Data.NumberOfCharactersInStationName = strlen(oMessage.Tun_ListElements.TunerListElement.at(i).sStationName.szValue);

    	if(oclCMPresetListContentUpdate_Data.NumberOfCharactersInStationName > 0)
    		oclCMPresetListContentUpdate_Data.ServiceName 					  = oMessage.Tun_ListElements.TunerListElement.at(i).sStationName.szValue;

    	oclCMPresetListContentUpdate_Data.ServiceNameEncoding 			  = oMessage.Tun_ListElements.TunerListElement.at(i).u8StationNameEncoding;
    	oclCMPresetListContentUpdate_Data.ProgramService 				  = oMessage.Tun_ListElements.TunerListElement.at(i).u8ProgramService;
    	oclCMPresetListContentUpdate_Data.Band 							  = U8GetTunerBand(oMessage.Tun_ListElements.TunerListElement.at(i).e8ListID.enType);
    	oclCMPresetListContentUpdate_Data_list.push_back(oclCMPresetListContentUpdate_Data);
		
		if(!m_bIsPresetListGetRequired)
		{
			if(m_u16ActivePresetList == oclCMPresetListContentUpdate_Data.FktIdOfList)
			{
				m_bIsPresetListGetRequired = true;
			}
		}
    }
	if(u8NumberOfPresetsToUpdate)
	{		
		m_poclAars_CM_PresetListContentUpdate->vPresetListContentUpdateStartResult(oMessage.UserID,TYPE_OF_PARAMETER_SET,u8NumberOfPresetsToUpdate,oclCMPresetListContentUpdate_Data_list);
	}
}

tVoid clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::vOnPresetListContentUpdateResult(tU8 u8Result)
{
	if(m_poATPresetList_XX == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: vOnPresetListContentUpdateResult , null pointer"));
		midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
		vSendMethodResult(oResult);
		return;
	}
	midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult oResult;
	if(u8Result)
	{
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
		vSendMethodResult(oResult);
		ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: vOnPresetListContentUpdateResult: m_u16ActivePresetList : %d", m_u16ActivePresetList));
		if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
		{
			m_poATPresetList_XX->vGetPresetList(PRESETLIST_00);
		}
		else if(m_u16ActivePresetList != 0xFF && m_bIsPresetListGetRequired)
		{
			
			m_poATPresetList_XX->vGetPresetList(m_u16ActivePresetList);
		}
		m_bIsPresetListGetRequired = false;
	}
	else
	{
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
		vSendMethodResult(oResult);
	}
}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::vTrace(midw_fi_tcl_TunerListElement oTunerPresetListElement)
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: Frequency: %d",oTunerPresetListElement.u32Frequency));
	ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: list: %d",U16GetADR3PresetListID(oTunerPresetListElement.e8ListID.enType)));
	ETG_TRACE_USR4(("clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE: u8ElementID: %d",oTunerPresetListElement.u8ElementID));

}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::vOnCM_PresetListContentUpdateError()
{
	//TODO
	//check what happens in adr in error case
	midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult oResult;
	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
	vSendMethodResult(oResult);
}
/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_PRESETLIST_CONTENT_UPDATE::vSetActivePresetList(tU16 u16ActivePresetList)
{
	m_u16ActivePresetList = u16ActivePresetList;
}

