/************************************************************************
 * FILE:           clTmcTuner_Method_S_LANGUAGE_SETTING.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_LANGUAGE_SETTING.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	Jul 21, 2017 		pmn3kor
 *************************************************************************/

#ifndef COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_LANGUAGE_SETTING_H_
#define COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_LANGUAGE_SETTING_H_

#include "CcaApp/clServerMethod.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "Aars/clAars_ATPresetList_XX.h"

#ifndef VARIANT_S_FTR_ENABLE_AIL_MOCK
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif


#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"
#else
#include "amt_mock/amt_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_DP_CLIENT_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_tuner_if.h"
#include "dp_generic_if.h"
#else
   #include"diaglib_if.h"
#endif

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"
/*----------------------------------------------------------------------*/
class clConfigInterface;

class clTmcTuner_Method_S_LANGUAGE_SETTING : public tuner::CcaApp::clServerMethod
{
public:
    virtual ~clTmcTuner_Method_S_LANGUAGE_SETTING();
    clTmcTuner_Method_S_LANGUAGE_SETTING( tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName,clAars_ATPresetList_XX* poclAars_ATPresetList_XX);
    /*Set function for m_LanguageSetting*/
    void vSetLanguageSetting(unsigned char u8LanguageType);
    /*get function for m_LanguageSetting*/
    unsigned char u8GetLanguageSetting();

private:
    virtual void vMethodStart(amt_tclServiceData* poInMsg);
    void vPostMethodResult(midw_fi_tcl_e8_Tun_ResponseStatus::tenType newValue);

    midw_tunerfi_tclMsgFID_TUN_S_LANGUAGE_SETTINGMethodStart m_oMessage;
    unsigned char m_LanguageSetting;
    clJapanStationName *m_poclJapanStationName;
    clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
};






#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_LANGUAGE_SETTING_H_ */
