/************************************************************************
 * FILE:           clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	24/08/2018	 | pmn3kor					  | Initial version of the file
 *************************************************************************/

#ifndef clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME_h
#define clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME_h

#include "CcaApp/clServerMethod.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "tun_Class_ForwardDecl.h"
#include "Aars/clAars_ATPresetList_XX.h"
/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/*----------------------------------------------------------------------*/

class clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME : public tuner::CcaApp::clServerMethod
{
public:
    virtual ~clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME();
    clTmcTuner_Method_S_JAPAN_SELECT_STATION_NAME( tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName, clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST,clAars_ATPresetList_XX *poclAars_ATPresetList_XX);

private:
    virtual void vMethodStart(amt_tclServiceData* poInMsg);
    clJapanStationName *m_poclJapanStationName;
    clTmcTuner_Property_G_JAPAN_STATION_NAME_LIST *m_poclTmcTuner_Property_G_JAPAN_STATION_NAME_LIST;
    midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodStart m_oMessage;
    midw_tunerfi_tclMsgFID_TUN_S_JAPAN_SELECT_STATION_NAMEMethodResult oResult;
    clAars_ATPresetList_XX* m_poclAars_ATPresetList_XX;
    /*check which type of selection mode is given by client and handle accordingly*/
    void vHandleSelectionMode();
    /*check the validity of element ID received from client*/
    void vHandleElementIDValue();
    /*check the validity of Direction received from client and respond accordingly*/
    void vHandleDirectionValue();

    //send station name list update after when name is not changed for 10sec.
    static OSAL_tpfCallback  vTimeoutNotificationCallback(void* pArg);
    static OSAL_tTimerHandle    m_hNotificationAfter10sec_Timer;
};


#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_SELECT_STATION_NAME_H_ */
