/************************************************************************
 * FILE:           clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
	26.08.2016				pmn3kor	
 *************************************************************************/
 

#ifndef COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_CHANGE_STATION_NAME_H_
#define COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_CHANGE_STATION_NAME_H_


#include "CcaApp/clServerMethod.h"
//#include "ADRMsg/ADRMsg_if.h"
#include "TunerApp/StationNameJapan/clJapanStationName.h"
#include "clTmcTuner_Property_G_JAPAN_AREA.h"

/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
/*----------------------------------------------------------------------*/

class clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME : public tuner::CcaApp::clServerMethod
{
public:
    virtual ~clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME();
    clTmcTuner_Method_S_JAPAN_CHANGE_STATION_NAME( tuner::CcaApp::clCCAhandler* poCCAhandler, clJapanStationName *poclJapanStationName);

private:
    virtual void vMethodStart(amt_tclServiceData* poInMsg);
    void vInterChangeStationMode();
    clJapanStationName *m_poclJapanStationName;
    midw_tunerfi_tclMsgFID_TUN_S_JAPAN_CHANGE_STATION_NAMEMethodStart m_oMessage;

    static OSAL_tpfCallback  vTimeoutNotificationCallback(void* pArg);
    static OSAL_tTimerHandle    m_hNotificationAfter10sec_Timer;
};


#endif /* COMPONENTS_FC_TMCTUNER_AMFMTUNER_CLTMCTUNER_METHOD_S_JAPAN_CHANGE_STATION_NAME_H_ */
