/************************************************************************
 * FILE:           clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/

#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "AMFMTuner/clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_HDTestMode.h"

using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT.cpp.trc.h"
#endif



/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT::~clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT()
{
   m_poHDTestMode = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT::clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT(clCCAhandler* poCCAhandler, clAars_HDTestMode* poHDTestMode)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_HD_RESET_TRANSITIONCOUNT, poCCAhandler)
   , m_poHDTestMode(poHDTestMode)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT::vMethodStart(amt_tclServiceData* /*poInMessage*/)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_HD_RESET_TRANSITIONCOUNT: MethodStart"));

   m_poHDTestMode->vResetTransitionCount();

   midw_tunerfi_tclMsgFID_TUN_S_HD_RESET_TRANSITIONCOUNTMethodResult oResult;
   vSendMethodResult(oResult);
}


