/************************************************************************
 * FILE:           clTmcTuner_Method_S_GET_STATIC_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_GET_STATIC_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/


#include "clTmcTuner_Method_S_GET_STATIC_LIST.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "ADRMsg/ADRMsg_if.h"
#include "conversionTable/midwTunerToAdr3Map.h"
using namespace tuner::CcaApp;
/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_GET_STATIC_LIST::~clTmcTuner_Method_S_GET_STATIC_LIST()
{
	m_poATPresetList_XX=0;
}


/*****************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_GET_STATIC_LIST::clTmcTuner_Method_S_GET_STATIC_LIST(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetList_XX* poATPresetList_XX)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, poCCAhandler)
    ,m_poATPresetList_XX(poATPresetList_XX)
{

}


/*****************************************************************************
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_GET_STATIC_LIST::vMethodStart(amt_tclServiceData* poInMessage)
{
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);
   unsigned short U16ADR3PresetListID =U16GetADR3PresetListID(m_oMessage.e8ListID.enType);
   midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodResult oResult;

  if(ADR_MSG_FID_INVALID!=U16ADR3PresetListID )
  {
	  m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
	  oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
  }
  else // if (U16ADR3PresetListID == ADR_MSG_FID_INVALID) ***fix for RTC-99095***
  {
	  oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
  }

  vSendMethodResult(oResult);
}
