/************************************************************************
 * FILE:           clTmcTuner_Method_S_GET_CONFIG_LIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_GET_CONFIG_LIST.h
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/



#ifndef clTmcTuner_Method_S_GET_CONFIG_LIST_h
#define clTmcTuner_Method_S_GET_CONFIG_LIST_h

#include "CcaApp/clServerMethod.h"
#include "ADRMsg/ADRMsg_if.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"

class clAars_CM_StationListConfig;
class clAars_CM_StationsList;
class clConfigInterface;
class clTmcTuner_Method_S_GET_CONFIG_LIST : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
public:
	virtual ~clTmcTuner_Method_S_GET_CONFIG_LIST();
	clTmcTuner_Method_S_GET_CONFIG_LIST( tuner::CcaApp::clCCAhandler* poCCAhandler, \
		clAars_CM_StationListConfig* poclAars_CM_StationListConfig\
		,clAars_CM_StationsList* poclAars_CM_StationsList);
	void vDecreementOpenStationListsCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	unsigned char u8GetOpenStationListsCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vClearOpenStationListsCount();
	
	bool bIsFMStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	bool bIsTMCStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	bool bIsAMStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vIncrementStationListCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	void vSet_tun_ConfigInterface_Ptr( clConfigInterface* poclConfigInterface );


private:
	virtual void vMethodStart(amt_tclServiceData* poInMsg);
	virtual void vOnCM_StationListConfigResult(unsigned char u8ListId,unsigned char u16NumberOfStations);
	clAars_CM_StationListConfig* m_poclAars_CM_StationListConfig;
	clAars_CM_StationsList* m_poclAars_CM_StationsList;
	void vSendStationListConfig( midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart oMessage);
	void vSendStationListConfig_GenericProxy( midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart oMessage);
	bool bIsStationListConfigureRequired(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId);
	unsigned char m_u8FMOpenStationListsCount;
	unsigned char m_u8AMOpenStationListsCount;
	clConfigInterface* m_poclConfigInterface;
	tBool blIsFMStationListConfigured;
	tBool blIsAMStationListConfigured;
	tU8 m_u8ReqListId;
};


#endif
