/************************************************************************
 * FILE:           clTmcTuner_Method_S_GET_CONFIG_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_GET_CONFIG_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/


#include "clTmcTuner_Method_S_GET_CONFIG_LIST.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_CM_StationListConfig.h"
#include "Aars/clAars_CM_StationsList.h"
#include "ADRMsg/ADRMsg_if.h"
#include "ADRMsg/types/clCMEnumTypes.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "kdsconfig/clConfigInterface.h"
using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_GET_CONFIG_LIST.cpp.trc.h"
#endif
/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_GET_CONFIG_LIST::~clTmcTuner_Method_S_GET_CONFIG_LIST()
{
	m_poclAars_CM_StationListConfig = 0;
	m_u8FMOpenStationListsCount = 0;
	m_u8AMOpenStationListsCount = 0;
	m_poclAars_CM_StationsList = NULL;
	m_poclConfigInterface = NULL;
	blIsFMStationListConfigured = false;
	blIsAMStationListConfigured = false;
	m_u8ReqListId = 0xFF;
}
/*****************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_GET_CONFIG_LIST::clTmcTuner_Method_S_GET_CONFIG_LIST(tuner::CcaApp::clCCAhandler* poCCAhandler, \
	clAars_CM_StationListConfig* poclAars_CM_StationListConfig, clAars_CM_StationsList* poclAars_CM_StationsList)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_GET_CONFIG_LIST, poCCAhandler)
{
	m_poclAars_CM_StationListConfig=poclAars_CM_StationListConfig;
	m_u8FMOpenStationListsCount = 0;
	m_u8AMOpenStationListsCount = 0;
	m_poclAars_CM_StationsList = poclAars_CM_StationsList;
	m_poclConfigInterface = NULL;
	blIsFMStationListConfigured = false;
	blIsAMStationListConfigured = false;
	m_u8ReqListId = 0xFF;
}


/*****************************************************************************
* vMethodStart
******************************************************************************/
void clTmcTuner_Method_S_GET_CONFIG_LIST::vMethodStart(amt_tclServiceData* poInMessage)
{
   midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
   if(poInMessage->u16GetSourceAppID() != CCA_C_U16_APP_GENERIC_PROXY)
   {
	   if(midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC==oMessage.TunMakeConfigList.eConfigListID.enType)
	   {
		   //vGetTMCStations();
	   }
	   else
	   {
		   vSendStationListConfig(oMessage);
	   }
   }
   else
   {
	   vSendStationListConfig_GenericProxy(oMessage);
   }
}
/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_GET_CONFIG_LIST::vSendStationListConfig( midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart oMessage)
{
    ETG_TRACE_USR1(("CCR.STARTING.STATION_LIST:MethodStart"));
	clCMStationListConfigStartResult oData;
	oData.ListId=U8GetADR3StationListID(oMessage.TunMakeConfigList.eConfigListID.enType);
	oData.Band = enGetADR3StationListBandBit(oMessage.TunMakeConfigList.eConfigListID.enType);
	oData.AnalogFilter.enType=clCMEnum_AnalogFilter::RDS_and_NON_RDS;
	if(NULL != m_poclConfigInterface)
	{
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		int u8CountryCode = m_poclConfigInterface->u32GetConfigData("RADIOCountryZone");
		if((0xFF != u8CountryCode) && (enPSA_TunerArea_Asia_China == u8CountryCode) || (enPSA_TunerArea_Korea == u8CountryCode))
		{
			oData.AnalogFilter.enType=clCMEnum_AnalogFilter::ALL;
		}
		#endif
	}
	oData.DigitalFilter=oMessage.TunMakeConfigList.u8DigitalFilters.u8Value;
	oData.PtyFilter=oMessage.TunMakeConfigList.u32PTY;
	tU8 u8sorting = (tU8)oMessage.TunMakeConfigList.eSortingCriteria.enType;
	oData.Sorting.enType=(clCMEnum_Sorting::enSorting)u8sorting;
	if(midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_DRM==oMessage.TunMakeConfigList.eConfigListID.enType)
	{
		oData.AnalogFilter.enType=clCMEnum_AnalogFilter::None;
		//pmn3kor : removing this line as suzuki sends pty filter now.
		//oData.PtyFilter=clCMEnum_PtyFilter::PtyFilter_None;
		oData.Sorting.enType=clCMEnum_Sorting::FREQUENCY_ASCENDING;
	}

	if(bIsStationListConfigureRequired((midw_fi_tcl_e8_Tun_ConfigListID::tenType)oData.ListId))
	{
		m_poclAars_CM_StationListConfig->vSendStationListConfig(oData);
	}
	else
	{
		if((bIsFMStationList((midw_fi_tcl_e8_Tun_ConfigListID::tenType)oData.ListId)) && (blIsFMStationListConfigured))
		{
		m_poclAars_CM_StationsList->vGetStationList(oMessage.TunMakeConfigList.eConfigListID.enType);
		}
		else if((bIsAMStationList((midw_fi_tcl_e8_Tun_ConfigListID::tenType)oData.ListId)) && (blIsAMStationListConfigured))
		{
			m_poclAars_CM_StationsList->vGetStationList(oMessage.TunMakeConfigList.eConfigListID.enType);
		}
		else if(oData.ListId == 6)
		{
			m_poclAars_CM_StationsList->vGetStationList(oMessage.TunMakeConfigList.eConfigListID.enType);
		}
		else
		{
		}
	}

	vIncrementStationListCount((midw_fi_tcl_e8_Tun_ConfigListID::tenType)oData.ListId);

}


/*****************************************************************************

******************************************************************************/
void clTmcTuner_Method_S_GET_CONFIG_LIST::vSendStationListConfig_GenericProxy( midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodStart oMessage)
{
    ETG_TRACE_USR1(("vSendStationListConfig_GenericProxy:MethodStart"));
	clCMStationListConfigStartResult oData;
	m_u8ReqListId = oMessage.TunMakeConfigList.eConfigListID.enType;
	oData.ListId = 0x03;
	oData.Band = enGetADR3StationListBandBit(oMessage.TunMakeConfigList.eConfigListID.enType);
	oData.AnalogFilter.enType=clCMEnum_AnalogFilter::RDS_and_NON_RDS;
	if(NULL != m_poclConfigInterface)
	{
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		int u8CountryCode = m_poclConfigInterface->u32GetConfigData("RADIOCountryZone");
		if((0xFF != u8CountryCode) && (enPSA_TunerArea_Asia_China == u8CountryCode) || (enPSA_TunerArea_Korea == u8CountryCode))
		{
			oData.AnalogFilter.enType=clCMEnum_AnalogFilter::ALL;
		}
		#endif
	}
	oData.DigitalFilter=oMessage.TunMakeConfigList.u8DigitalFilters.u8Value;
	oData.PtyFilter=oMessage.TunMakeConfigList.u32PTY;
	tU8 u8sorting = (tU8)oMessage.TunMakeConfigList.eSortingCriteria.enType;
	oData.Sorting.enType=(clCMEnum_Sorting::enSorting)u8sorting;
	if(midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_DRM==oMessage.TunMakeConfigList.eConfigListID.enType)
	{
		oData.AnalogFilter.enType=clCMEnum_AnalogFilter::None;
		//pmn3kor : removing this line as suzuki sends pty filter now.
		//oData.PtyFilter=clCMEnum_PtyFilter::PtyFilter_None;
		oData.Sorting.enType=clCMEnum_Sorting::FREQUENCY_ASCENDING;
	}

	m_poclAars_CM_StationListConfig->vSendStationListConfig(oData);
}


void clTmcTuner_Method_S_GET_CONFIG_LIST::vIncrementStationListCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	if(bIsFMStationList(e8ListId))
	{
		m_u8FMOpenStationListsCount++;
	}
	else if(bIsAMStationList(e8ListId))
	{
		m_u8AMOpenStationListsCount++;
	}
	
}


void clTmcTuner_Method_S_GET_CONFIG_LIST::vOnCM_StationListConfigResult(unsigned char u8ListId,unsigned char u8NumberOfStations)
{
	midw_tunerfi_tclMsgFID_TUN_S_GET_CONFIG_LISTMethodResult oMessageResult;
	oMessageResult.TunMakeConfigListElem.u8NumOfElementsInList=u8NumberOfStations;

	if(u8ListId != 0x03)
	{
		if(bIsFMStationList((midw_fi_tcl_e8_Tun_ConfigListID::tenType)u8ListId))
		{
			blIsFMStationListConfigured = true;
		}
		else if(bIsAMStationList((midw_fi_tcl_e8_Tun_ConfigListID::tenType)u8ListId))
		{
			blIsAMStationListConfigured = true;
		}
		oMessageResult.TunMakeConfigListElem.e8ListID.enType=(midw_fi_tcl_e8_Tun_ConfigListID::tenType)u8ListId;
	}
	else
	{
		oMessageResult.TunMakeConfigListElem.e8ListID.enType=(midw_fi_tcl_e8_Tun_ConfigListID::tenType)m_u8ReqListId;
	}

	vSendMethodResult(oMessageResult);
}

bool clTmcTuner_Method_S_GET_CONFIG_LIST::bIsStationListConfigureRequired(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	bool bResult = false;


	switch(e8ListId)
	{
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM :
		{			
			bResult = m_u8FMOpenStationListsCount == 0 ? true:false;
		}
		break;

	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW :
		{
			bResult = m_u8AMOpenStationListsCount == 0 ? true:false;
		}
		break;

	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM :
		{
			bResult = m_u8AMOpenStationListsCount == 0 ? true:false;
		}
		break;

	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC :
		{
			bResult = true;
		}
		break;

	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_DRM :
		{
			bResult = true;
		}
		break;
	case midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_LW :
		{
			bResult = true;
		}
		break;

	default :
		{
			bResult = false;
		}
		break;

	}

	ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::bIsStationListConfigureRequired = %d m_u8FMOpenStationListsCount = %d m_u8AMOpenStationListsCount = %d blIsFMStationListConfigured=%d blIsAMStationListConfigured=%d"
		,bResult, m_u8FMOpenStationListsCount,m_u8AMOpenStationListsCount,blIsFMStationListConfigured,blIsAMStationListConfigured));

	return bResult;

}

bool clTmcTuner_Method_S_GET_CONFIG_LIST::bIsFMStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	return e8ListId == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_FM ? true : false;
}

bool clTmcTuner_Method_S_GET_CONFIG_LIST::bIsTMCStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	return e8ListId == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_TMC ? true : false;
}

bool clTmcTuner_Method_S_GET_CONFIG_LIST::bIsAMStationList(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	if(e8ListId == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_AM ||
		e8ListId == midw_fi_tcl_e8_Tun_ConfigListID::FI_EN_TUN_TUN_CONFIG_LIST_MW )
	{
		return true;
	}
	else
	{
		return false;
	}
}


void clTmcTuner_Method_S_GET_CONFIG_LIST::vDecreementOpenStationListsCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	if(bIsFMStationList(e8ListId))
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::vDecreementOpenStationListsCount m_u8FMOpenStationListsCount = %d",m_u8FMOpenStationListsCount ));
		m_u8FMOpenStationListsCount > 0 ? m_u8FMOpenStationListsCount-- : 0 ;
		if(!m_u8FMOpenStationListsCount)
		{
			blIsFMStationListConfigured = false;
		}
	}
	else if(bIsAMStationList(e8ListId))
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::vDecreementOpenStationListsCount m_u8AMOpenStationListsCount = %d",m_u8AMOpenStationListsCount ));
		m_u8AMOpenStationListsCount > 0 ? m_u8AMOpenStationListsCount-- : 0 ;
		if(!m_u8AMOpenStationListsCount)
		{
			blIsAMStationListConfigured = false;
		}
	}

}

unsigned char clTmcTuner_Method_S_GET_CONFIG_LIST::u8GetOpenStationListsCount(midw_fi_tcl_e8_Tun_ConfigListID::tenType e8ListId)
{
	if(bIsFMStationList(e8ListId))
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::u8GetOpenStationListsCount m_u8FMOpenStationListsCount = %d",m_u8FMOpenStationListsCount ));
		return m_u8FMOpenStationListsCount;
	}
	else if(bIsAMStationList(e8ListId))
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::u8GetOpenStationListsCount m_u8AMOpenStationListsCount = %d",m_u8AMOpenStationListsCount ));
		return m_u8AMOpenStationListsCount;
	}
	else if(bIsTMCStationList(e8ListId))
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::u8GetOpenStationListsCount m_u8TMCOpenStationListsCount = %d",1 ));
		return 1;
	}
	else
	{
		ETG_TRACE_USR4(( "clTmcTuner_Method_S_GET_CONFIG_LIST::u8GetOpenStationListsCount Default case = %d",0 ));
		return 0;
	}

}

void clTmcTuner_Method_S_GET_CONFIG_LIST::vClearOpenStationListsCount()
{
	m_u8FMOpenStationListsCount = 0;
	m_u8AMOpenStationListsCount = 0;
}
void clTmcTuner_Method_S_GET_CONFIG_LIST::vSet_tun_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface )
{
	m_poclConfigInterface = poclConfigInterface;
}