/************************************************************************
 * FILE:           clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
 * 28/08/2017    | pmn3kor					  | Implementation for FID_TUN_S_DRM_RESET_MUTECOUNTER
 *************************************************************************/

#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "AMFMTuner/clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/clTmcTuner_Property_DRM_TestMode.h"

using namespace tuner::CcaApp;

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGTOHMI
#include "trcGenProj/Header/clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER::~clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER()
{
	m_poDRMTestMode = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER::clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER(clCCAhandler* poCCAhandler, clTmcTuner_Property_DRM_TestMode* poDRMTestMode)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DRM_RESET_MUTECOUNTER, poCCAhandler)
   , m_poDRMTestMode(poDRMTestMode)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER::vMethodStart(amt_tclServiceData* /*poInMessage*/)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_DRM_RESET_MUTECOUNTER: MethodStart"));

   m_poDRMTestMode->vResetMuteCounter();

   midw_tunerfi_tclMsgFID_TUN_S_DRM_RESET_MUTECOUNTERMethodResult oResult;
   vSendMethodResult(oResult);
}





