/************************************************************************
 * FILE:           clTmcTuner_Method_S_DISABLE_BAND.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DISABLE_BAND.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						
 *************************************************************************/


#include "clTmcTuner_Method_S_DISABLE_BAND.h"
#include "clTmcTuner_Property_G_GET_STATIC_LIST.h"
#include "CcaApp/clCCAhandler.h"
#include "Aars/clAars_ATPresetList_XX.h"
#include "Aars/clAars_CM_ChangeLsm.h"
#include "Aars/clAars_ATFrequency.h"
#include "ADRMsg/ADRMsg_if.h"
#include "conversionTable/midwTunerToAdr3Map.h"
#include "tun_trace.h"
#include "tun_defines.h"
#include "tun_MsgFromHMI.h"
#include "config/dp_tclTunerImpl.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MSGFROMHMI
#include "trcGenProj/Header/clTmcTuner_Method_S_DISABLE_BAND.cpp.trc.h"
#endif

using namespace tuner::CcaApp;
/*****************************************************************************
* Destructor
******************************************************************************/
clTmcTuner_Method_S_DISABLE_BAND::~clTmcTuner_Method_S_DISABLE_BAND()
{
	m_poATPresetList_XX=0;
	m_poclAars_CM_ChangeLsm=0;
	m_potun_Config=0;
	m_stDisableBandRequest.blIsDisableBandRequested=0;
	m_stDisableBandRequest.midwTunerBand=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
	m_poclTmcTuner_Property_G_GET_STATIC_LIST=0;
	m_poclAars_ATFrequency=0;
	m_potun_MsgFromHMI=0;
	m_podp_tclTunerImpl=0;
}


/*****************************************************************************
* Constructor
******************************************************************************/
clTmcTuner_Method_S_DISABLE_BAND::clTmcTuner_Method_S_DISABLE_BAND(tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATPresetList_XX* poATPresetList_XX,clAars_CM_ChangeLsm* poclAars_CM_ChangeLsm,tun_Config* potun_Config,clTmcTuner_Property_G_GET_STATIC_LIST* poclTmcTuner_Property_G_GET_STATIC_LIST,clAars_ATFrequency* poclAars_ATFrequency,tun_MsgFromHMI* potun_MsgFromHMI)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DISABLE_BAND, poCCAhandler)
    ,m_poATPresetList_XX(poATPresetList_XX)
{
	m_poclAars_CM_ChangeLsm=poclAars_CM_ChangeLsm;
	m_potun_Config = potun_Config;
	m_stDisableBandRequest.blIsDisableBandRequested=0;
	m_stDisableBandRequest.midwTunerBand=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
	m_poclTmcTuner_Property_G_GET_STATIC_LIST=poclTmcTuner_Property_G_GET_STATIC_LIST;
	m_poclAars_ATFrequency=poclAars_ATFrequency;
	m_potun_MsgFromHMI=potun_MsgFromHMI;
	m_podp_tclTunerImpl=0;
}
tVoid clTmcTuner_Method_S_DISABLE_BAND::vSetdp_tclTunerImplPtr(dp_tclTunerImpl* podp_tclTunerImpl)
{
	m_podp_tclTunerImpl=podp_tclTunerImpl;
}

/*****************************************************************************
* vMethodStart
******************************************************************************/
tVoid clTmcTuner_Method_S_DISABLE_BAND::vMethodStart(amt_tclServiceData* poInMessage)
{
   if((m_potun_Config ==NULL)|| (m_poclAars_CM_ChangeLsm==NULL)||(m_poATPresetList_XX==NULL))
   {
	    ETG_TRACE_USR4(( "vMethodStart null pointer tun_Config=%p clAars_CM_ChangeLsm=%p ATPresetList_XX=%p",
			m_potun_Config,m_poclAars_CM_ChangeLsm,m_poATPresetList_XX));
	   return;
   }
   midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart oMessage;
   m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
   /*Disable Band is supported only for AM Source, fix for RTC issue 253252*/
   if((midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_CB1 != oMessage.u8Band.enType) && ( midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW != oMessage.u8Band.enType) && ( midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW != oMessage.u8Band.enType))
   {
		midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
		vSendMethodResult(oResult);	
		return;
   }
   m_stDisableBandRequest.blIsDisableBandRequested=true;
   m_stDisableBandRequest.midwTunerBand=oMessage.u8Band.enType;
   unsigned short U16ADR3PresetListID=U16GetADR3PresetListID(oMessage.u8Band.enType);
   //If the system is not supported mixed preset list
   if(m_potun_Config->u8GetPresetListType() !=TUN_CONFIG_PRESETLIST_TYPE_MIXED)
   {
		ETG_TRACE_USR4(( "DisableBand::Request --> Delete preset list =%d",U16ADR3PresetListID));	
		//Send a request to delete correspoding presetlist
		m_poATPresetList_XX->vDeleteAllPreset(U16ADR3PresetListID);
		m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
   }
   else
   {
		ETG_TRACE_USR4(( "DisableBand::Request -->Delete mixed preset list element which contain =%d",U16ADR3PresetListID));
		m_poclTmcTuner_Property_G_GET_STATIC_LIST->vDisableBand_DeletePresetElement(oMessage.u8Band.enType);
		m_poATPresetList_XX->vGetPresetList(U16ADR3PresetListID);
	}
	//Change the LSM of the request Diable Band
	ETG_TRACE_USR4(( "DisableBand::band=%d m_poclAars_ATFrequency=%p",m_potun_MsgFromHMI->u8GetCurrentBand(),m_poclAars_ATFrequency));
	if(m_potun_MsgFromHMI->u8GetCurrentBand()==oMessage.u8Band.enType)
	{
		m_poclAars_ATFrequency->vSelectDirectFrequency(m_potun_Config->u32GetLSMFrequency(oMessage.u8Band.enType));
	}
	else
	{
		m_poclAars_CM_ChangeLsm->vSendChangeLSMDirectFreqInput((tU8)oMessage.u8Band.enType, m_potun_Config->u32GetLSMFrequency(oMessage.u8Band.enType),0x0);
	}
}
stDisableBandRequest clTmcTuner_Method_S_DISABLE_BAND::stGetDisableBandRequested()
{
	return m_stDisableBandRequest;
}
tVoid clTmcTuner_Method_S_DISABLE_BAND::vSendDisableBandMethodResult()
{
	if(NULL!=m_podp_tclTunerImpl)
	{
		m_podp_tclTunerImpl->getTunerDPValue(enAMAvailabilityHMIStatusDp);
		m_podp_tclTunerImpl->vSetTunerDPValue(enAMAvailabilityHMIStatusDp,false);

		m_stDisableBandRequest.blIsDisableBandRequested=0;
		m_stDisableBandRequest.midwTunerBand=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
		midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodResult oResult;
		oResult.TunerServer_StatusResponse.u8TunerStatus.enType=midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
		vSendMethodResult(oResult);
	}
}
