/************************************************************************
 * FILE:         clTmcTuner_Method_S_DIRECT_FREQUENCY.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DIRECT_FREQUENCY.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						auj1kor
				
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_DIRECT_FREQUENCY.h"
#include "CcaApp/clCCAhandler.h"
#include "tun_MsgToHMI.h"
#include "tun_MsgFromHMI.h"
#include "tun_ActualData.h"
#include "tun_Msg_types.h"
#include "Aars/clAars_ATPresetListSetActive.h"
#include "Aars/clAars_ATFrequency.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "TunerApp/Mute/MuteHandling/clMuteImpl.h"
#include "conversionTable/midwTunerToAdr3Map.h"

using namespace tuner::CcaApp;
using namespace Mute::MuteHandling;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_DIRECT_FREQUENCY.cpp.trc.h"
#endif


clTmcTuner_Method_S_DIRECT_FREQUENCY::~clTmcTuner_Method_S_DIRECT_FREQUENCY()
{
	m_poATFrequency = NULL;
}
clTmcTuner_Method_S_DIRECT_FREQUENCY::clTmcTuner_Method_S_DIRECT_FREQUENCY( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_ATFrequency* poATFrequency)
:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY, poCCAhandler)
, m_poATFrequency(poATFrequency)
{

}

tVoid clTmcTuner_Method_S_DIRECT_FREQUENCY::vMethodStart(amt_tclServiceData* poInMsg)
{
    ETG_TRACE_USR4(("clTmcTuner_Method_S_DIRECT_FREQUENCY: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult oResult;

    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
	tU8 u8CurrentBand = 0xFF;
	if(poInMsg->u16GetSourceAppID() == CCA_C_U16_APP_DIAGDEBUG)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DIRECT_FREQUENCY: Msg from Diagnosis"));
		u8CurrentBand = ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u8PrevBand;
	}
	else
	{
		u8CurrentBand = ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_ActualData->m_otun_Data_Station.u8GetBand();
	}
	vStoreMuteData(m_oMessage.u32Frequency);
    if(poInMsg->u16GetSourceAppID() != CCA_C_U16_APP_TUNERMASTER)
    {
        ETG_TRACE_USR4(("clTmcTuner_Method_S_DIRECT_FREQUENCY: Msg not from Tuner master"));
		/*Bug fix 252134 mhv6kor Added check if AM FM tuner is in FG */
        if(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_Config->bGetFrequencyValid(u8CurrentBand, m_oMessage.u32Frequency) && (((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->bIsTunerFG()))
        {
            vOnNewMuteTunerAction(Mute::MuteHandling::DIRECTFREQUENCY);
        }
        else if(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->m_u32ATStationFreq != m_oMessage.u32Frequency)
        {
            oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_FAIL;
        }
    }
    else
    {
        vHandleMethodStartFromTunerMasterApp(poInMsg);
    }
    vSendMethodResult(oResult);
 }
 
 void clTmcTuner_Method_S_DIRECT_FREQUENCY::vHandleMethodStartFromTunerMasterApp(amt_tclServiceData* poInMsg)
 {
    tU8 u8CurrentBand = ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_ActualData->m_otun_Data_Station.u8GetBand();
    ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->vSetDirectFreqRequested(TRUE);
    ((tun_MsgFromHMI*)m_poCCAhandler)->m_u32DirectFreq = m_oMessage.u32Frequency;

    ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->vSetTunerMasterCommandCntrForDirectFreq(poInMsg->u16GetCmdCounter());
    ((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_MsgToHMI->vSetTunerMasterRegIDForDirectFreq(poInMsg->u16GetRegisterID());

    vProcessTunerAction();

    /** if preset type is mixed preset then  skip the below part as there is only one preset list*/
    if(!((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_Config->u8GetPresetListType())
    {
       /*If frequency is not valid for the current band, send the preset list active -- solution for NIKAI-6231*/
       if(!(((tun_MsgFromHMI*)m_poCCAhandler)->m_potun_Config->bGetFrequencyValid(u8CurrentBand, m_oMessage.u32Frequency)))
       {
          if(((tun_MsgFromHMI*)m_poCCAhandler)->m_poclAars_ATPresetListSetActive  == NULL)
          {
             NORMAL_M_ASSERT( ((tun_MsgFromHMI*)m_poCCAhandler)->m_poclAars_ATPresetListSetActive != NULL );
             return;
          }
          if(u8CurrentBand == (tU8)FI_EN_TUN_BAND_FM)
          {
             ((tun_MsgFromHMI*)m_poCCAhandler)->m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_MW));
          }
          else if (u8CurrentBand == (tU8)FI_EN_TUN_BAND_MW)
          {
             ((tun_MsgFromHMI*)m_poCCAhandler)->m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_FM));
          }
          else if (u8CurrentBand == (tU8)FI_EN_TUN_BAND_CB1)
          {
             ((tun_MsgFromHMI*)m_poCCAhandler)->m_poclAars_ATPresetListSetActive->vSendATPresetListSetActive(U16GetADR3PresetListID((midw_fi_tcl_e8_Tun_TunerBand::tenType)FI_EN_TUN_BAND_CB1));
          }
       }
    }
 }

void clTmcTuner_Method_S_DIRECT_FREQUENCY::vOnNewMuteTunerAction(Mute::MuteHandling::enMuteTuningAction muteAction)
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_DIRECT_FREQUENCY::vOnNewMuteTunerAction()"));
    clMuteImpl::instance()->vOnNewMuteTunerAction(muteAction);
}

void clTmcTuner_Method_S_DIRECT_FREQUENCY::vProcessTunerAction()
{
    ETG_TRACE_USR4(( "clTmcTuner_Method_S_DIRECT_FREQUENCY::vProcessTunerAction: u32Frequency = %d", m_oMuteData.m_u32Frequency));
    if(m_oMuteData.bIsStoredDataValid())
    {
        m_poATFrequency->vSelectDirectFrequency(m_oMuteData.m_u32Frequency);
        vClearStoredRequest();
    }
}

bool clDirectFrequencyMuteData::bIsStoredDataValid()
{
    if(m_u32Frequency != 0)
    {
        return true;
    }
    return false;
}

void clTmcTuner_Method_S_DIRECT_FREQUENCY::vOnAudioMuteRequest()
{

}
void clTmcTuner_Method_S_DIRECT_FREQUENCY::vOnDemuteSendMethodResult()
{

}
void clTmcTuner_Method_S_DIRECT_FREQUENCY::vOnTunerStateIdle()
{

}

clDirectFrequencyMuteData::clDirectFrequencyMuteData() : m_u32Frequency(0)
{
}

void clTmcTuner_Method_S_DIRECT_FREQUENCY::vStoreMuteData(unsigned int u32Frequency)
{
	m_oMuteData.m_u32Frequency = u32Frequency;
}

void clTmcTuner_Method_S_DIRECT_FREQUENCY::vClearStoredRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_DIRECT_FREQUENCY::vClearStoredRequest()"));
	m_oMuteData.m_u32Frequency = 0;
}


