/************************************************************************
 * FILE:         clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.h
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						auj1kor
				
 *************************************************************************/


#ifndef CLTMCTUNER_METHOD_S_DARC_VICS_FREQUENCY_LIST_H_
#define CLTMCTUNER_METHOD_S_DARC_VICS_FREQUENCY_LIST_H_


#include "CcaApp/clServerMethod.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "interface/clTmcTuner_HMI_ImpInterface.h"


class clAars_CM_DARC_SetFrequency;
class clTmcTuner_Property_G_GET_DARC_DATA;

class clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST : public tuner::CcaApp::clServerMethod, public clTmcTuner_HMI_ImpInterface
{
public:
    virtual ~clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST();
    clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_DARC_SetFrequency* poDARCSetFrequency);

    tVoid vSet_G_GET_DARC_DATA_Ptr(clTmcTuner_Property_G_GET_DARC_DATA* poclTmcTuner_Property_G_GET_DARC_DATA);
    tVoid vRequestDARCData();
    tU32  u32GetRequstedDARCDataFreq();

private:
    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg);

    clAars_CM_DARC_SetFrequency* m_poDARC_SetFrequency;
    clTmcTuner_Property_G_GET_DARC_DATA* m_poclTmcTuner_Property_G_GET_DARC_DATA;

    midw_fi_tcl_u32FrequencyList m_oFrequencyData;
    tU8 m_u8DARCFreqListIndex;
    tU32 m_u32DARCDataReqFreq;

};

#endif /* CLTMCTUNER_METHOD_S_DARC_VICS_FREQUENCY_LIST_H_ */
