/************************************************************************
 * FILE:         clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
						auj1kor
				
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.h"
#include "AMFMTuner/clTmcTuner_Property_G_GET_DARC_DATA.h"
#include "CcaApp/clCCAhandler.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "Aars/clAars_CM_DARC_SetFrequency.h"

using namespace tuner::CcaApp;

#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST.cpp.trc.h"
#endif


clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::~clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST()
{
	  m_u8DARCFreqListIndex = 0;
	  m_u32DARCDataReqFreq = 0;
	  m_poDARC_SetFrequency = NULL;
	  m_poclTmcTuner_Property_G_GET_DARC_DATA = NULL;
}


clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST( tuner::CcaApp::clCCAhandler* poCCAhandler, clAars_CM_DARC_SetFrequency* poDARCSetFrequency)
			:clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_DARC_VICS_FREQUENCY_LIST, poCCAhandler)
{
	m_poDARC_SetFrequency = poDARCSetFrequency;
	m_poclTmcTuner_Property_G_GET_DARC_DATA = NULL;
	m_u8DARCFreqListIndex = 0;
	m_u32DARCDataReqFreq = 0;

}

tVoid clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::vSet_G_GET_DARC_DATA_Ptr(clTmcTuner_Property_G_GET_DARC_DATA* poclTmcTuner_Property_G_GET_DARC_DATA)
{
	if(poclTmcTuner_Property_G_GET_DARC_DATA != NULL)
	{
		m_poclTmcTuner_Property_G_GET_DARC_DATA = poclTmcTuner_Property_G_GET_DARC_DATA;
	}
}


tVoid clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::vMethodStart(amt_tclServiceData* poInMsg)
{
	if(m_poclTmcTuner_Property_G_GET_DARC_DATA == NULL)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST: vMethodStart , null pointer"));
		return;
	}
    ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST: MethodStart"));
    midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodStart m_oMessage;
    midw_tunerfi_tclMsgFID_TUN_S_DARC_VICS_FREQUENCY_LISTMethodResult oResult;
    m_poCCAhandler->vGetDataFromAmt(poInMsg, m_oMessage);
    if(m_oFrequencyData.FrequencyValues.size() != 0)
    {
        m_oFrequencyData.FrequencyValues.clear();
    }
    m_oFrequencyData  = m_oMessage.FrequencyData;
    m_poclTmcTuner_Property_G_GET_DARC_DATA->vStopDARCTimer();
    m_u8DARCFreqListIndex = 0;
    vRequestDARCData();

	oResult.TunerServer_StatusResponse.u8TunerStatus.enType = midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED;
	oResult.TunerServer_StatusResponse.u8TunerState.enType = midw_fi_tcl_e8_Tun_ResponseState::FI_EN_TUN_TUN_STATE_NORMAL;

	vSendMethodResult(oResult);
}


tVoid clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::vRequestDARCData()
{
	if((m_poclTmcTuner_Property_G_GET_DARC_DATA == NULL) || (m_poDARC_SetFrequency == NULL))
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST: vRequestDARCData , null pointer"));
		return;
	}
	if(m_oFrequencyData.FrequencyValues.size() == 0)
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST: Request for DARC data received when list is empty"));
	}
	else
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST, size of frequency list : %d ", m_oFrequencyData.FrequencyValues.size()));
		if(m_u8DARCFreqListIndex < m_oFrequencyData.FrequencyValues.size())
		{
			m_u32DARCDataReqFreq = m_oFrequencyData.FrequencyValues.at(m_u8DARCFreqListIndex);
			m_u8DARCFreqListIndex++;
			m_poDARC_SetFrequency->vSendSetDARCFrequency(m_u32DARCDataReqFreq);
			m_poclTmcTuner_Property_G_GET_DARC_DATA->vStopDARCTimer();
			m_poclTmcTuner_Property_G_GET_DARC_DATA->vStartDARCTimer(); // request for next frequency from list once the timer expires.
		}
		else if(m_u8DARCFreqListIndex == m_oFrequencyData.FrequencyValues.size())
		{
			ETG_TRACE_USR4(("clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST, end of list reached start from first frequency"));
			m_u8DARCFreqListIndex = 0;
			vRequestDARCData();
		}
		else
		{
			// invalid
		}
	}
}


tU32 clTmcTuner_Method_S_DARC_VICS_FREQUENCY_LIST::u32GetRequstedDARCDataFreq()
{
	if(m_oFrequencyData.FrequencyValues.size() != 0)
	{
		return m_u32DARCDataReqFreq;
	}
	else
	{
		return 0;
	}
}


