/************************************************************************
 * FILE:         clTmcTuner_Method_S_AudioMuteRequest.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of  clTmcTuner_Method_S_AudioMuteRequest
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "AMFMTuner/clTmcTuner_Method_S_AudioMuteRequest.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"
#include "drmPlayer/drmPlayerInterface.h"

#include "tun_trace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_MUTE_HANDLER
#include "trcGenProj/Header/clTmcTuner_Method_S_AudioMuteRequest.cpp.trc.h"
#endif

using namespace tuner::drm;
using namespace tuner::CcaApp;
using namespace Mute;
using namespace Mute::MuteHandling;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_AudioMuteRequest::~clTmcTuner_Method_S_AudioMuteRequest()
{
	m_poMuteImpl = 0;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_AudioMuteRequest::clTmcTuner_Method_S_AudioMuteRequest(clCCAhandler* poCCAhandler)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_MUTEREQUEST, poCCAhandler)
{
	m_poMuteImpl = clMuteImpl::instance();
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_S_AudioMuteRequest::vMethodStart(amt_tclServiceData* /*poInMessage*/ )
{
	vOnAudioMuteRequest();
}


tVoid clTmcTuner_Method_S_AudioMuteRequest::vOnAudioMuteRequest()
{
	ETG_TRACE_USR4(( "clTmcTuner_Method_S_AudioMuteRequest::vOnAudioMuteRequest()"));
	m_poMuteImpl->vOnAudioMuteRequest();
}
