/************************************************************************
 * FILE:        clTmcTuner_Method_S_AUDIO_FG_BG_NEW.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_S_AUDIO_FG_BG_NEW.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/


#include "AMFMTuner/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.h"
#include "CcaApp/clCCAhandler.h"

#include "Aars/clAars_MTCAudioSource.h"
#include "Aars/clAars_AudioSource.h"
#include "Aars/clAars_SpecialDiagnosisMode.h"
#include "tun_MsgFromHMI.h"
#include "tun_MsgToHMI.h"
#include "tun_ActualData.h"
#include "tun_defines.h"
#include "kdsconfig/clConfigInterface.h"
#include "AMFMTuner/clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY.h"

using namespace tuner::CcaApp;


#include "tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clTmcTuner_Method_S_AUDIO_FG_BG_NEW.cpp.trc.h"
#endif

//#define MeasureMode_ON 1
#define MeasureMode_OFF 0

/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_S_AUDIO_FG_BG_NEW::~clTmcTuner_Method_S_AUDIO_FG_BG_NEW()
{
   m_poMTCAudioSource = NULL;
   m_poAudioSource = NULL;
   m_poSpecialDiagnosisMode  = NULL;
   m_potun_MsgFromHMI = NULL;
   m_u8TunerMode = midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_AUTO;
   m_u8MeasurementMode = 0;
   m_potun_MsgToHMI = NULL;
   m_potun_ActualData = NULL;
   m_blBandChangeRequested = 0;
   m_poclConfigInterface = nullptr;
   m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_S_AUDIO_FG_BG_NEW::clTmcTuner_Method_S_AUDIO_FG_BG_NEW(clCCAhandler* poCCAhandler, clAars_AudioSource* poAudioSource, clAars_MTCAudioSource* poMTCAudioSource,  clAars_SpecialDiagnosisMode* poSpecialDiagnosisMode,
				tun_MsgToHMI* potun_MsgToHMI, tun_ActualData* potun_ActualData,clConfigInterface* poclConfigInterface) : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW, poCCAhandler)
   , m_poMTCAudioSource(poMTCAudioSource)
   , m_poAudioSource(poAudioSource)
   , m_poSpecialDiagnosisMode(poSpecialDiagnosisMode)
   , m_potun_MsgFromHMI(NULL)
   , m_potun_MsgToHMI(potun_MsgToHMI)
   , m_potun_ActualData(potun_ActualData)
   , m_poclConfigInterface(poclConfigInterface)
   , m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY(NULL)
   , m_u8TunerMode(midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_AUTO)
   , m_u8MeasurementMode(0)
{
	m_blBandChangeRequested =0;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSet_tun_MsgFromHMI_Ptr( tun_MsgFromHMI* potun_MsgFromHMI )
{
  if( potun_MsgFromHMI != NULL )
  {
    m_potun_MsgFromHMI = ( tun_MsgFromHMI* )potun_MsgFromHMI;
  }
  else
  {
    ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: vSet_tun_MsgFromHMI_Ptr , Null Pointer"));
  }
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSet_TmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCYPtr( clTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY* poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY )
{
  if( poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY != NULL )
  {
	  m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY = poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY;
  }
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vMethodStart(amt_tclServiceData* poInMessage)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: MethodStart"));
   m_poCCAhandler->vGetDataFromAmt(poInMessage, m_oMessage);
   if (bIsTestModeActive())
   {
      vTestModeReq();
   }
   else
   {
      if (bIsToForegroundRequest())
      {
         vOnForeGroundRequest();
      }
      else
      {
         vOnBackGroundRequest();
      }
   }
}


/**************************************************************************//**
* 
******************************************************************************/
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::bIsTestModeActive()
{
   if (m_oMessage.TunAudFGBGNew.u8_PhysicalTuner.enType == midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_INVALID_TYPE)
   {
      return false;
   }
   return true;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::bIsToForegroundRequest()
{
	/*For MTC_AudioSource don't rely on subcommand. Only rely on u8_TunerHeader parameter. */
	if(m_poclConfigInterface == nullptr)
	{
		return false;
	}
	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
	   if (m_oMessage.TunAudFGBGNew.u8_TunerHeader.enType == midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND) { return true; }
	}
	else
	{
		if (m_oMessage.TunAudFGBGNew.u8SubCommand.enType == midw_fi_tcl_e8_Tun_SubCommand::FI_EN_TUN_CHANGE_TO_FG) { return true; }
	}
	return false;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vOnForeGroundRequest()
{
	if(m_poclConfigInterface == nullptr)
	{
		return;
	}
		
	ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: vOnForeGroundRequest() Band - %d", (tU8)m_oMessage.TunAudFGBGNew.e8Band.enType));

	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
		ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: vOnForeGroundRequest() MTCSource - %d", (tU8)m_oMessage.TunAudFGBGNew.e8MTCAudioSource.enType));
		m_poMTCAudioSource->vSetAudioSource((clCMEnum_MTCAudioSource::enMTCAudioSource)m_oMessage.TunAudFGBGNew.e8MTCAudioSource.enType);
		
		if((!m_poclConfigInterface->u32GetConfigData("PresetListType")) && (m_oMessage.TunAudFGBGNew.e8Band.enType != midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID))
			m_potun_MsgFromHMI->vHandle_ChangeBand((tU8)m_oMessage.TunAudFGBGNew.e8Band.enType);
	}
	else
	{
		m_poAudioSource->vSetAudioSource(getAudioSource());
		if(m_oMessage.TunAudFGBGNew.e8Band.enType != midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID)
			m_potun_MsgFromHMI->vHandle_ChangeBand((tU8)m_oMessage.TunAudFGBGNew.e8Band.enType);
	}
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vOnBackGroundRequest()
{
	if(m_poclConfigInterface == nullptr)
	{
		return;
	}
	if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
		m_poMTCAudioSource->vSetAudioSource(clCMEnum_MTCAudioSource::NotHeardSource);
	}
	else
	{
	   if (bIsTunerInForeGround() && bIsNonUserSink())
	   {
		   m_poAudioSource->vSetAudioSource(clCMEnum_AudioSource::User_Audio);
	   }
	   else
	   {
		   m_poAudioSource->vSetAudioSource(clCMEnum_AudioSource::No_Audio);
	   }
	}
}


/**************************************************************************//**
* 
******************************************************************************/
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::bIsTunerInForeGround()
{
   if (m_oMessage.TunAudFGBGNew.bTunerState)
   {
      return false;
   }
   return true;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::bIsNonUserSink()
{
   if (m_oMessage.TunAudFGBGNew.u8AudioSink.enType == midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_TA_CHANGE_TO_FG_BG ||
      m_oMessage.TunAudFGBGNew.u8AudioSink.enType == midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_PTY_CHANGE_TO_FG_BG ||
      m_oMessage.TunAudFGBGNew.u8AudioSink.enType == midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_WEATHERALERT_CHANGE_TO_FG_BG)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/

clCMEnum_AudioSource::enAudioSource clTmcTuner_Method_S_AUDIO_FG_BG_NEW::getAudioSource()
{
	clCMEnum_AudioSource audioSource;
   switch (m_oMessage.TunAudFGBGNew.u8AudioSink.enType)
   {
   case midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_USR1_CHANGE_TO_FG_BG:
	   audioSource.enType = clCMEnum_AudioSource::User_Audio;
	   break;
   case midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_TA_CHANGE_TO_FG_BG:
	   audioSource.enType = clCMEnum_AudioSource::TA_Audio;
	   break;
   case midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_PTY_CHANGE_TO_FG_BG:
	   audioSource.enType = clCMEnum_AudioSource::PTY_Audio;
	   break;
   case midw_fi_tcl_e8_Tun_AudioSink::FI_EN_TUN_WEATHERALERT_CHANGE_TO_FG_BG:
      audioSource.enType = clCMEnum_AudioSource::WeatherAlert_Audio;
      break;
   default:
	   break;
   }
   return audioSource.enType;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vTestModeReq()
{
   ETG_TRACE_USR4(("Tuner Mode = %d     Measure Mode = %d", u8GetTunerMode(), u8GetMeasureMode()));
   switch(u8GetTunerMode() )
   {
   case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_SINGLE:
   {
      if(u8GetMeasureMode() == MeasureMode_OFF)
      {
         m_poSpecialDiagnosisMode->vSetSpecialDiagnosisMode(clCMSpecialDiagnosisMode::SINGLETUNER_MODE, (unsigned char) (m_oMessage.TunAudFGBGNew.u8_PhysicalTuner.enType));
      }
      else
      {
    	  m_poSpecialDiagnosisMode->vSetSpecialDiagnosisMode(clCMSpecialDiagnosisMode::MEASURE_MODE, (unsigned char) (m_oMessage.TunAudFGBGNew.u8_PhysicalTuner.enType));
      }
      break;
   }
   case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_AUTO:
   case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_DDA:
   case midw_fi_tcl_e8_DDADDS_Mode::FI_EN_TUN_DDS:
   {
         /*In production diagnosis session, measure mode will be not be active. Bugfix for PSARCCB-7778*/
		 //if(u8GetMeasureMode() == MeasureMode_ON)
         m_poSpecialDiagnosisMode->vSetSpecialDiagnosisMode(clCMSpecialDiagnosisMode::MEASURE_MODE, (unsigned char) (m_oMessage.TunAudFGBGNew.u8_PhysicalTuner.enType));
      break;
   }
   default:
   {
      ETG_TRACE_USR4(("Invalid Tuner Mode. u8GetTunerMode = %d", u8GetTunerMode()));
      break;
   }
   }
}


/**************************************************************************//**
* 
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vOnNewTunerFGBGStatus(unsigned char AudioSource)
{
   ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: vOnNewTunerFGBGStatus %d", AudioSource));
   if((nullptr == m_potun_MsgToHMI) || (nullptr == m_poclConfigInterface) || (nullptr == m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY))
   {
	   return;
   }
   m_potun_MsgToHMI->vSetTunFGBGStatus(AudioSource);
   
   if(m_poclConfigInterface->u32GetConfigData("SBR"))
	{
	   m_oResult.TunAudioFgBgStatus.e8MTCAudioSource.enType = (midw_fi_tcl_e8_Tun_MTCAudioSource::tenType)AudioSource;
	   if((clCMEnum_MTCAudioSource::enMTCAudioSource)AudioSource == clCMEnum_MTCAudioSource::NotHeardSource)
	   {
		   /*Do not wait for tunerState idle for BG request */
		   m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType= midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_BACKGROUND;
		   vSendMethodResult(m_oResult);
		   m_poclTmcTuner_Property_G_AUDIO_AMPLIFIER_FREQUENCY->vSendSwitchingFrequency(TUN_SWITCHING_FREQUENCY_432kHz);
	   }
	   else
	   {
		   m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType= midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;
		   switch(AudioSource)
		   {
		   case clCMEnum_MTCAudioSource::User_audio_FM:
		   case clCMEnum_MTCAudioSource::User_audio_LW:
		   case clCMEnum_MTCAudioSource::User_audio_MW:
		   case clCMEnum_MTCAudioSource::User_audio_TRF:
		   case clCMEnum_MTCAudioSource::User_audio_WB:
		   case clCMEnum_MTCAudioSource::User_audio_CB1:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG;
			   break;
		   case clCMEnum_MTCAudioSource::User_audio_DAB:
		   {
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG;
			   vSendFGBGMethodResult();
			   break;  
		   }
		   case clCMEnum_MTCAudioSource::Anno_audio_RDS:
	       case clCMEnum_MTCAudioSource::Road_traffic_flash_audio_DAB:
		   case clCMEnum_MTCAudioSource::Transport_flash_audio_DAB:
		   case clCMEnum_MTCAudioSource::Warning_flash_audio_DAB:
		   case clCMEnum_MTCAudioSource::News_flash_audio_DAB:
		   case clCMEnum_MTCAudioSource::Weather_flash_audio_DAB:
		   case clCMEnum_MTCAudioSource::Event_announcement_audio_DAB:
		   case clCMEnum_MTCAudioSource::Special_event_audio_DAB:
		   case clCMEnum_MTCAudioSource::Programme_information_audio_DAB:
		   case clCMEnum_MTCAudioSource::Sport_report_audio_DAB:
		   case clCMEnum_MTCAudioSource::Financial_report_audio_DAB:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG;
			   break;
		   case clCMEnum_MTCAudioSource::PTY31_audio_RDS:
		   case clCMEnum_MTCAudioSource::Alarm_audio_DAB:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG;
			   break;
		   default:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = 0;
			   break;
		   }
	   }
	}
	else
	{
	   if((clCMEnum_AudioSource::enAudioSource)AudioSource == clCMEnum_AudioSource::No_Audio)
	   {
		   m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType= midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_BACKGROUND;
		   /*Do not wait for tunerState idle for BG request */
		   vSendMethodResult(m_oResult);
	   }
	   else
	   {
		   m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType= midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;
		   switch(AudioSource)
		   {
		   case clCMEnum_AudioSource::User_Audio:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG;
			   break;
		   case clCMEnum_AudioSource::TA_Audio:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_TA_SWITCHED_TUN_TOFG;
			   break;
		   case clCMEnum_AudioSource::PTY_Audio:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_PTY_SWITCHED_TUN_TOFG;
			   break;
		   case clCMEnum_AudioSource::WeatherAlert_Audio:
            m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_RESERVED1;
            break;
		   default:
			   m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value = 0;
			   break;
		   }
	   }
	}
}
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::IsUserSwitchedTunerToFG()
{
	if((m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType== midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND) && (m_oResult.TunAudioFgBgStatus.u8AudioSink.u8Value == midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG))
	{
		return true;
	}
	else
	{
		return false;
	}
}
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSendFGBGMethodResult()
{
	ETG_TRACE_USR4(("clTmcTuner_Method_S_AUDIO_FG_BG_NEW: vSendFGBGMethodResult tunerState = %d", (tU8)m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType));
	m_blBandChangeRequested =0;
	vSendMethodResult(m_oResult);
	m_oResult.TunAudioFgBgStatus.u8_TunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE;
}

/*****************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSetTunerMode(unsigned char u8NewVal)
{
   m_u8TunerMode = u8NewVal;
}
/*****************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_AUDIO_FG_BG_NEW::u8GetTunerMode()
{
   return m_u8TunerMode;
}
/*****************************************************************************
*
******************************************************************************/
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSetMeasureMode(unsigned char u8NewVal)
{
   m_u8MeasurementMode = u8NewVal;
}
/*****************************************************************************
*
******************************************************************************/
unsigned char clTmcTuner_Method_S_AUDIO_FG_BG_NEW::u8GetMeasureMode()
{
   return m_u8MeasurementMode;
}
bool clTmcTuner_Method_S_AUDIO_FG_BG_NEW::bIsBandChangeRequested()
{
	return m_blBandChangeRequested;
}
void clTmcTuner_Method_S_AUDIO_FG_BG_NEW::vSetBandChangeRequested(bool val)
{
	m_blBandChangeRequested = val;
}
