/************************************************************************
 * FILE:           clTmcTuner_Method_AudioDevice.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   fc_tmctuner
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of clTmcTuner_Method_AudioDevice.cpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification

 *************************************************************************/



#include "AMFMTuner/clTmcTuner_Method_AudioDevice.h"
#include "AMFMTuner/tmcTuner_amfmTunerService_fi.h"
#include "CcaApp/clCCAhandler.h"

#ifdef VARIANT_S_FTR_ENABLE_DRM
#include "drmPlayer/drmPlayerInterface.h"
using namespace tuner::drm;
#endif

using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clTmcTuner_Method_AudioDevice::~clTmcTuner_Method_AudioDevice()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clTmcTuner_Method_AudioDevice::clTmcTuner_Method_AudioDevice(clCCAhandler* poCCAhandler)
   : clServerMethod(MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_DEVICE, poCCAhandler)
{
}


/**************************************************************************//**
* 
******************************************************************************/
tVoid clTmcTuner_Method_AudioDevice::vMethodStart(amt_tclServiceData* poInMessage )
{
	midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart oMessage;
	m_poCCAhandler->vGetDataFromAmt(poInMessage, oMessage);
#ifdef VARIANT_S_FTR_ENABLE_DRM
   drmPlayerInterface* player = drmPlayerInterface::getInstance();
   if (0 != player)
   {
      player->vSetSink(oMessage.sDRMAudioSinkName.szValue, 0);
   }
#endif
   midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult oResult;
   vSendMethodResult(oResult);
}

