//====================================================================
// MWT_Output_Files:
//
// This handles writing the output of the processing library
// to a file.
//
//====================================================================

//====================================================================
// Required includes
//====================================================================
#include "MW_DataFieldTypes.h"
#include "MW_Transmogrifier.h"

//====================================================================
// MWOutputFiles_setFilePath:
//
// Sets the file path that will be used for output until
// called again.
//====================================================================
TMW_ResultCode MWOutputFiles_setFilePath
(
	const char* pstr_filePath
);

//====================================================================
// MWOutputFiles_endFile:
//
// Closes the current file stream.
//====================================================================
TMW_ResultCode MWOutputFiles_endFile( void );

//====================================================================
// MWOutputFiles_outputBytes:
//
// The callback which writes bytes to the current file.
//
//====================================================================
TMW_ResultCode MWOutputFiles_outputBytes
(
	TFourByteInteger_Unsigned numBytes,
	TByte_Unsigned* p_bytes
);
