//====================================================================
// MWT_Output_Files.c:
//
// Implementation of the file output ADT for testing of the
// WSI receiver library.
//
//====================================================================

//====================================================================
// includes
//====================================================================
#include <stdio.h>
#include "MWT_Output_Files.h"

//====================================================================
// Module Local variables
//====================================================================
static FILE* p_currentFile = NULL;

//====================================================================
// Public methods
//====================================================================

TMW_ResultCode MWOutputFiles_setFilePath
(
	const char* pstr_filePath
)
{
	//##############################################################
	// Test parameters
	//##############################################################
	if (pstr_filePath == NULL)
	{
		return MWRes_NullPointer;
	}

	//##############################################################
	// Close any previous file
	//##############################################################
	if (p_currentFile != NULL)
	{
		fclose(p_currentFile);
		p_currentFile = NULL;
	}

	//##############################################################
	// Open file for binary write, replace if already exists
	//##############################################################
	p_currentFile = fopen
	(
		pstr_filePath,
		"wb"
	);
	if (p_currentFile == NULL)
	{
		return MWRes_OperationFailed;
	}

	//##############################################################
	// Success
	//##############################################################
	return MWRes_Success;

}

//--------------------------------------------------------------------

TMW_ResultCode MWOutputFiles_endFile()
{
	if (p_currentFile != NULL)
	{
		fclose(p_currentFile);
		p_currentFile = NULL;
	}

	return MWRes_Success;
}

//--------------------------------------------------------------------

TMW_ResultCode MWOutputFiles_outputBytes
(
	TFourByteInteger_Unsigned numBytes,
	TByte_Unsigned* p_bytes
)
{
	size_t numWritten;

	//##############################################################
	// Test parameters
	//##############################################################
	if (p_bytes == NULL)
	{
		return MWRes_NullPointer;
	}

	//##############################################################
	// Test state
	//##############################################################
	if (p_currentFile == NULL)
	{
		return MWRes_CommunicationsError;
	}

	//##############################################################
	// Write to file
	//##############################################################
	numWritten = fwrite
	(
		p_bytes,
		1,
		numBytes,
		p_currentFile
	);
	if (numWritten != numBytes)
	{
		return MWRes_CommunicationsError;
	}

	//##############################################################
	// Success
	//##############################################################
	return MWRes_Success;
}
