/*
//====================================================================
// MW_DownsampledDeflatedRLEProcessor.h:
//
// This is the interface of an Abstract Data Type which handles the
// processing of Deflated RLE rasters that have been downsampled
// in resolution.
//
// The raster is read into memory, uncompressed, upsampled to the
// resolution stated in the generic raster header, and then
// passed to the output encoder.
//
// The Acronymn MWDDRLE is used throughout this module to stand
// for "Mobile Weather Downsampled Deflated RLE " in order to
// preserve the fingers of humanity.
//
// Author: Damon M. Hill
// Copyright � 2005 WSI Corporation.  All rights reserved.
//
//====================================================================
*/

#ifndef MW_DOWNSAMPLEDDEFLATEDRLEPROCESSOR_HEADER
#define MW_DOWNSAMPLEDDEFLATEDRLEPROCESSOR_HEADER

/*
//====================================================================
// Required includes
//====================================================================
*/

#include "MW_DataFieldTypes.h"

/*
//====================================================================
// MWDDRLE_transformFormat:
//
// This method is used to transform a raster body from the
// WSI Downsampled Deflated RLE format to the specified format.
//
// The output result is sent through the MWOutputDPUEncoder.
//
// PARAMETERS:
//
//	numBodyBytes:
//		This indicates the number of deflated body bytes in the caller's
//		array.
//
//	p_bytes:
//		This is the array of bytes holding the product body, starting at
//		the first byte of the product body (after the header and ICF and OCF
//		flags.
//
//	bool_productEndsWithThisBody:
//
//		If set to 0, then the last frame required to output this raster body
//		is not marked as the end of the product.
//
//		If set to !0, then the last frame required to output this raster body
//		is marked as the end of the product.
//
// numUpsampledRasterColumns:
//		The number of columns in the raster at its final resolution (once upsmapled)
//
// numUpsampledRasterRows:
//		The number of rows in the raster body at its final resolution
//
// numBitsPerPixel:
//		The number of bits per pixel in the raster body
//		Valid values are currently 1-8
//
// p_out_numBytesConsumed:
//		This returns the number of bytes consumed from the body block
//
// RETURNS:
//
//	MWRes_Success
//		If this is returned, the body has been written to the output
//
//
//	MWRes_ProductContentsInvalid:
//		If the downsampled size found in the product block header
//		is larger in either dimension than the upsampled size
//		passed in by the caller.
//
//	MWRes_UnrecognizedTransmogrificationType:
//		If the outputFormat is not one of the supported types
//		(see PARAMETERS section)
//
//		If the numBitsPerPixel is not in then inclusive range 1 to 8
//
//	MWRes_OutOfMemory:
//		If the raster product is too large to work with given our
//		fixed memory constraints.
//
//	MWRes_NullPointer:
//		If a pointer parameter is NULL
//====================================================================
*/
TMW_ResultCode MWDDRLE_transformFormat
(
	TFourByteInteger_Unsigned numBodyBytes,
	TByte_Unsigned* p_bytes,
	TByte_Unsigned bool_productEndsWithThisBody,
	TTwoByteInteger_Unsigned numRasterColumns,
	TTwoByteInteger_Unsigned numRasterRows,
	TByte_Unsigned numBitsPerPixel,
	TFourByteInteger_Unsigned* p_out_numBytesConsumed
);



/* end header wrapper */
#endif

