/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
 *
 *  \file sxm_platform_internal.h
 *  \author Alexander Pylchagin
 *  \date 9/12/2016
 *  \brief Platform dependent primitives
 *
 ******************************************************************************/

#ifndef SXM_PLATFORM_INTERNAL_H_
#define SXM_PLATFORM_INTERNAL_H_

#include "sxm_build.h"
#include "sxm_typ.h"

#ifndef SDKFILES_STANDALONE_BUILD

#include <pthread.h>

/** \name Threads
 * @{
 */
/** Assignees name to the thread via its pthread handle.
 * \param[in] thread handle of the thread which should have new name
 * \param[in] name null-terminated string which represents new name
 * \return Nothing
 */
extern SXESDK_INTERNAL_API void sxe_thread_setname(pthread_t thread, const char *name);

/** Creates new thread with provided parameters.
 * \param[out] tid id of newly created thread on success
 * \param[in] attr thread attributes definition structure, or NULL for default
 * \param[in] start main thread work function
 * \param[in] arg user context for the new thread
 * \return 0 on success or non-null on error
 */
extern SXESDK_INTERNAL_API int sxm_pthread_create (pthread_t *tid,
    const pthread_attr_t *attr, void *(*start) (void *), void *arg);
/** @} */
#endif

/** \name Semaphores
 * @{
 */
typedef struct sxm_sem_t_* SXMSem_t;

extern SXESDK_INTERNAL_API int sxm_sem_init(SXMSem_t *, unsigned int);
extern SXESDK_INTERNAL_API int sxm_sem_post(SXMSem_t *);
extern SXESDK_INTERNAL_API int sxm_sem_wait(SXMSem_t *);
extern SXESDK_INTERNAL_API int sxm_sem_trywait(SXMSem_t *);
extern SXESDK_INTERNAL_API int sxm_sem_timedwait(SXMSem_t *, unsigned int);
extern SXESDK_INTERNAL_API int sxm_sem_destroy(SXMSem_t *);

/** @} */

/** \name Time Specific
 * @{
 */
 
extern SXESDK_INTERNAL_API void sxe_usleep(uint nsec);

/** @} */

#endif /* SXM_PLATFORM_INTERNAL_H_ */
