/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
*
* \file sxm_csv.h
* \author Sergey Kotov
* \date 7/12/2016
*
* Header for the CSV Parser
*
*******************************************************************************/

#ifndef SXM_CSV_H
#define SXM_CSV_H

#include <stdlib.h>
#include <sxm_build.h>
#include <sxm_typ.h>

#ifdef __cplusplus
extern "C"
{
#endif

enum {
    /** CSV Parser creation options */
    SXM_CSV_OPTION_NONE = 0x00,
    /** If set, CSV Parser will itself free data pointed by pData parameter */
    SXM_CSV_OPTION_DATA_OWNER = 0x01,
    /** Means that the input file has no header */
    SXM_CSV_OPTION_NO_HEADER = 0x02,
    /** If set, file content is completely loaded into RAM on parser creation */
    SXM_CSV_OPTION_LOAD_TO_MEMORY = 0x04,
    /** If set, quotes processing is ignored */
    SXM_CSV_OPTION_IGNORE_QUOTES = 0x08
};

typedef struct _csv SxmCsvParser;

extern SXESDK_INTERNAL_API int sxm_csv_buffer_new(char *pData,
                                                  size_t dataSize,
                                                  uint lineSizeMax,
                                                  uint options,
                                                  char separator,
                                                  SxmCsvParser **ppRet);

extern SXESDK_INTERNAL_API int sxm_csv_file_new(const char *fileName,
                                                uint lineSizeMax,
                                                char separator,
                                                uint options,
                                                SxmCsvParser **ppRet);

extern SXESDK_INTERNAL_API void sxm_csv_delete(SxmCsvParser *pCsv);

extern SXESDK_INTERNAL_API int sxm_csv_get_pos(SxmCsvParser *pCsv, size_t *pPos);

extern SXESDK_INTERNAL_API int sxm_csv_set_pos(SxmCsvParser *pCsv, size_t pos);

extern SXESDK_INTERNAL_API int sxm_csv_skip_line(SxmCsvParser *pCsv);

extern SXESDK_INTERNAL_API int sxm_csv_reset(SxmCsvParser *pCsv);

extern SXESDK_INTERNAL_API int sxm_csv_next_line(SxmCsvParser *pCsv);

extern SXESDK_INTERNAL_API int sxm_csv_index(SxmCsvParser *pCsv,
                                             const char *colName);

extern SXESDK_INTERNAL_API const char * sxm_csv_str_val(SxmCsvParser *pCsv,
                                                        uint index,
                                                        int *pRc);

extern SXESDK_INTERNAL_API int sxm_csv_get_str_val(SxmCsvParser *pCsv,
                                                   uint index,
                                                   char *pDstBuf,
                                                   uint dstBufSize);

extern SXESDK_INTERNAL_API int sxm_csv_get_char_val(SxmCsvParser *pCsv,
                                                    uint index,
                                                    char *pRet);

extern SXESDK_INTERNAL_API int sxm_csv_int_val(SxmCsvParser *pCsv,
                                               uint index,
                                               int *pRc);

extern SXESDK_INTERNAL_API int sxm_csv_get_int_val(SxmCsvParser *pCsv,
                                                   uint index,
                                                   int *pRet);

extern SXESDK_INTERNAL_API int sxm_csv_get_fix_val(SxmCsvParser *pCsv,
                                                   uint index,
                                                   fix *pRet);

extern SXESDK_INTERNAL_API uint sxm_csv_current_line(SxmCsvParser *pCsv);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SXM_CSV_H */
