/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
*
* \file lli.h
* \author Leslie French
* \date 8/20/2013
* \brief Implementation of the common Low-level-interface API
*    for components using the SDK directly
*
*******************************************************************************/
#ifndef LLI_H
#define LLI_H

#include <util/sxm_common_internal.h>

extern int sxm_lli_core_rfd_init(SXMRfdService*,const SXMDataService*);

extern FILE *sxm_lli_core_rfd_open(SXMRfdService*, SXMRfdMetadata*, int);

extern int sxm_lli_core_rfd_start(SXMRfdService*, SXMDataService*, SXMRfdMetadata*);

extern int sxm_lli_core_rfd_status(SXMRfdService *, int, SXMRfdMetadata *);

extern int sxm_lli_core_rfd_remove(SXMRfdService *, int);

extern int sxm_lli_core_rfd_add(SXMRfdService*,
									byte*,
									int);

extern void sxm_lli_core_rfd_stop(SXMRfdService*);

extern int sxm_lli_core_rfd_permil_complete(SXMRfdService *, uint, int *);

#endif
