/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/*******************************************************************************
*
*$Workfile:      sxm_typ.h $
*$Author(s):     Victor Abreu $
*$Creation Date: 11/14/2013 $
*
*DESCRIPTION
*
*	Global Type definitions.
*
*******************************************************************************/

#ifndef SXM_TYP_H
#define SXM_TYP_H

/*==========================> INCLUDE FILES <=================================*/



/*==========================> DEFINITION <====================================*/

/*******************/
/* CONST           */
/*******************/
typedef const unsigned char CUINT8;

/*******************/
/* UINT8           */
/*******************/
typedef unsigned char UINT8;
#ifndef UINT8MAX
#define UINT8MAX ((UINT8)~0)
#endif
/*******************/
/* INT             */
/*******************/
typedef signed char INT8;

/*******************/
/* UINT16           */
/*******************/
typedef unsigned short int UINT16;
#ifndef UINT16MAX
#define UINT16MAX ((UINT16)~0)
#endif

/*******************/
/* INT16           */
/*******************/
typedef signed short int INT16;

/*******************/
/* CUINT16          */
/*******************/
typedef const unsigned short int CUINT16;

/*******************/
/* UINT32         */
/*******************/
typedef unsigned int UINT32;
#ifndef UINT32MAX
#define UINT32MAX ((UINT32)~0)
#endif

/*******************/
/* INT32          */
/*******************/
typedef int INT32;


/*******************/
/* BOOL            */
/*******************/
typedef int BOOL;

#ifdef FALSE
#undef FALSE
#endif
#define FALSE	(0)

#ifdef TRUE
#undef TRUE
#endif
#define TRUE	(!FALSE)

/*============================================================================*/

/************************************************************************
 *                                                                      *
 *            Legacy SDK Types                                          *
 *            ================                                          *
 *                                                                      *
 ************************************************************************/

typedef unsigned int uint;
typedef unsigned short ushort;
typedef unsigned char byte;
typedef void *ptr;
typedef int fix;

#endif /* SXM_TYP_H */


