/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/*******************************************************************************
*
*   $Workfile:      sxm_sdk.h $
*   $Author(s):     Leslie French (refactoring by Victor Abreu)$
*   $Creation Date: 01/22/2014 $
*
*   DESCRIPTION
*
*
*
*
*******************************************************************************/

/*==========================> INCLUDE FILES <=================================*/

#ifndef SXMSDK_H
#define SXMSDK_H

#include "sxm_build.h"

#ifndef SXM_COMMON_H
#include <sxm_common.h>
#endif


#if (!SXM_USE_GEN8)
#include "sxm_sxi.h"
#else
#include "sxm_sxi8.h"
#include "sxm_wbmd.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*==========================> DEFINITION <====================================*/

/***********************************/
/* SCAN PLAY INTERVALS (seconds)   */
/***********************************/
#define PLAY_SEC_MIN                  2
#define PLAY_SEC_MAX                 15

/*****************************************/
/* EXTENDED CHANNEL METADATA VALID BITS  */
/*****************************************/
#define CH_SHORT_VALID_BIT              (0)
#define CH_LONG_VALID_BIT               (1)
#define RELATED_CH_LIST_VALID_BIT       (2)
#define CH_LIST_ORDER_VALID_BIT         (3)
#define PLAY_ON_SELECT_VALID_BIT        (4)
#define CH_CONTENT_TYPE_VALID_BIT       (5)
#define PB_NAV_CLASS_VALID_BIT          (6)
#define SHADOW_REC_CLASS_VALID_BIT      (7)

/*==========================> LEGACY SUPPORT DEFINITION  <=====================*/
#if (SXM_USE_GEN8)
#define SXI_CHAN_NAME_SHORT_MAX             (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CHAN_NAME_MED_MAX               (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CHAN_NAME_LONG_MAX              (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CAT_NAME_SHORT_MAX              (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CAT_NAME_MED_MAX                (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CAT_NAME_LONG_MAX               (SXM_WBMD_CHN_NAME_MAX_SIZE)
#define SXI_CHANNEL_SHORT_DESCRIPTION_MAX   (SXM_WBMD_CHN_DESC_MAX_SIZE)
#define SXI_CHANNEL_LONG_DESCRIPTION_MAX    (SXM_WBMD_CHN_DESC_MAX_SIZE)
#define SXI_RELATED_CHAN_LIST_MAX           (SXM_WBMD_CHN_AFFIN2_MAX_SIZE)
#endif

/*************************/
/* SXM CATEGORY          */
/*************************/
typedef struct {
    byte id;                                            /* Category Indentifier */
    char cats[SXI_CAT_NAME_SHORT_MAX];                  /* Category Name associated with CatID, Short format */
    char catm[SXI_CAT_NAME_MED_MAX];                    /* Category Name associated with CatID, Medium format */
    char catl[SXI_CAT_NAME_LONG_MAX];                   /* Category Name associated with CatID, Long format */
}SXMCategory;

/*************************/
/* SXM CHANNEL ALL       */
/* BASIC AND EXTENDED    */
/*************************/
typedef struct {
    ushort id;                                          /* Channel Number (aka Identifier)*/
    byte catid;                                         /* Category Identifier (Nework Category Identifier) */
    byte refcat;                                        /* Reference Category Identifier */
    byte attr;                                          /* Attributes of the channel and content */
    byte rr;                                            /* Recording restriction flags */
    char names[SXI_CHAN_NAME_SHORT_MAX];                /* Channel Name, Short format */
    char namem[SXI_CHAN_NAME_MED_MAX];                  /* Channel Name, Medium format */
    char namel[SXI_CHAN_NAME_LONG_MAX];                 /* Channel Name, Long format */
    char cats[SXI_CAT_NAME_SHORT_MAX];                  /* Category Name associated with CatID, Short format */
    char catm[SXI_CAT_NAME_MED_MAX];                    /* Category Name associated with CatID, Medium format */
    char catl[SXI_CAT_NAME_LONG_MAX];                   /* Category Name associated with CatID, Long format */

    //  extended channel metadata (channel descriptions, channel list order, play on select,...)
    byte valid;                                         /* Extended Channel Metadata vaild status --
                                                           Flags used to mark which fields are actually valid */
//#if (!SXM_USE_GEN8)
    char descs[SXI_CHANNEL_SHORT_DESCRIPTION_MAX];      /* Channel Short Description */
    char descl[SXI_CHANNEL_LONG_DESCRIPTION_MAX];       /* Channel Long Description */
    ushort ymal[SXI_RELATED_CHAN_LIST_MAX];             /* Related Channel List */
//#endif
    ushort clo;                                         /* Channel List Order */
    byte pos;                                           /* Play On Select */
    byte cct;                                           /* Channel Content Type */
    byte irnc;                                          /* Playback Navigation Class */
    byte src;                                           /* Shadow Record Class */
}SXMChannel;


/*************************/
/* SXM CHANNEL BASIC     */
/*************************/
typedef struct {
    //basic channel metadata (channel number, channel names, category names,...)
    ushort id;                                          /* Channel Number (aka Identifier)*/
    byte catid;                                         /* Category Identifier (Nework Category Identifier) */
    byte refcat;                                        /* Reference Category Identifier */
    byte attr;                                          /* Attributes of the channel and content */
    byte rr;                                            /* Recording restriction flags */
#if (!SXM_USE_GEN8)
    char names[SXI_CHAN_NAME_SHORT_MAX];                /* Channel Name, Short format */
    char namem[SXI_CHAN_NAME_MED_MAX];                  /* Channel Name, Medium format */
    char namel[SXI_CHAN_NAME_LONG_MAX];                 /* Channel Name, Long format */
    char cats[SXI_CAT_NAME_SHORT_MAX];                  /* Category Name associated with CatID, Short format */
    char catm[SXI_CAT_NAME_MED_MAX];                    /* Category Name associated with CatID, Medium format */
    char catl[SXI_CAT_NAME_LONG_MAX];                   /* Category Name associated with CatID, Long format */
#endif
}SXMChannelBas;


/*************************/
/* SXM ID/SID            */
/*************************/
typedef struct {
    ushort id;                                          /*  channel number */
    ushort sid;                                         /* Service Identifier */
} SXMIdSid;

/*************************/
/* SXM CHAN ID/SID       */
/*************************/
typedef struct {
    ushort id;                                          /*  channel number */
    ushort sid;                                         /* Service Identifier */
    byte catid;                                         /* Reference Category Identifier */
    byte attr;                                          /* Attributes of the channel and content (SKIPPED, LOCKED, MATURE...) */
} SXMChannelId;

/*************************/
/* SXM CHAN ID/SID/NAME  */
/*************************/
typedef struct {
    ushort id;                                          /*  channel number */
    ushort sid;                                         /* Service Identifier */
    byte catid;                                         /* Reference Category Identifier */
    byte attr;                                          /* Attributes of the channel and content (SKIPPED, LOCKED, MATURE...) */
    char namel[SXI_CHAN_NAME_LONG_MAX];                 /* Channel Name, Long format */
} SXMChannelIdName;


/*************************/
/* SXM DISPLAY           */
/*************************/
typedef struct {
    byte code;                                          /* SXI Indication Code (NOMINAL, CHECK ANTENNA, NO SIGNAL,..,etc) */
    byte valid;                                         /* Channel Information Valid, indicates whether following fields are vaild */
    ushort id;                                          /* Channel Identifier (aka Channel number)*/
#if (!SXM_USE_GEN8)
    char names[SXI_CHAN_NAME_SHORT_MAX];                /* Channel Name, Short format */
    char namem[SXI_CHAN_NAME_MED_MAX];                  /* Channel Name, Medium format */
    char namel[SXI_CHAN_NAME_LONG_MAX];                 /* Channel Name, Long format */
#endif
}SXMDisplay;

/*************************/
/* SXM EVENT             */
/*************************/
#define SXI_EVENT_DATA_SIZE             10
typedef struct {
    byte code;                                       /* event code, EV_SYS_RESET - host reset to the SXM module */
    ushort data[SXI_EVENT_DATA_SIZE];                /* event data */
}SXMEvent;

/*************************/
/* SXM LEAGUE            */
/*************************/
#if (!SXM_USE_GEN8)
#if (!SXM_USE_GMD)
typedef struct {
    int id;                                          /* SXI_GMI_SPORTS_LEAGUE_ID */
    char sn[SXI_LEAGUE_SHORT_NAME_MAX];              /* SXI_GMI_SPORTS_LEAGUE_SHORT_NAME */
    char ln[SXI_LEAGUE_LONG_NAME_MAX];               /* SXI_GMI_SPORTS_LEAGUE_LONG_NAME */
    char lt[SXI_LEAGUE_TYPE_MAX];                    /* SXI_GMI_SPORTS_LEAGUE_TYPE */
    char sfe;                                        /* SXI_GMI_SPORTS_LEAGUE_SF_ENABLED */
    char sft;                                        /* SXI_GMI_SPORTS_LEAGUE_SF_TIERS */
}SXMLeague;
#endif
#endif

/*************************/
/* SXM PACKAGE           */
/*************************/
#define SXM_PKG_DATA_SIZE           50
typedef struct {
    byte buffer[SXM_PKG_DATA_SIZE];
} SXMPackage;

/******************************************/
/* Module features and capabilities Masks */
/******************************************/
#define SXM_MODULE_CAP_NONE           (0x00)
#define SXM_MODULE_CAP_IR             (0x01) // Bit 0
#define SXM_MODULE_CAP_RECORDING      (0x02) // Bit 1
#define SXM_MODULE_CAP_EXT_CHANNELS   (0x04) // Bit 2
#define SXM_MODULE_CAP_I2S_SLAVE      (0x08) // Bit 3
#define SXM_MODULE_CAP_ADVANCED_IR    (0x10) // Bit 4
#define SXM_MODULE_CAP_EXP_SMARTFAVS  (0x20) // Bit 5
#define SXM_MODULE_CAP_IP_AUTH        (0x40) // Bit 6
#define SXM_MODULE_CAP_MREF_MODE      (0x80) // Bit 7

/***************************/
/* SXM RECORD INFO         */
/* (Module Instant Replay) */
/***************************/
typedef struct {
    byte state;                                     /* Indicates the record state of the audio stream (active or inactive)*/
    byte buffer;                                    /* Portion of the recording buffer for this audio stream currently in use */
    ushort newest_id;                               /* The playback ID of the newest track stored in the Instant Replay buffer */
    ushort oldest_id;                               /* The playback ID of the oldest track stored in the Instant Replay buffer */
    ushort newest_dur;                              /* Duration in seconds of the newest track stored in the Instant Replay buffer */
    ushort oldest_dur;                              /* Duration in seconds of the oldest track stored in the Instant Replay buffer. */
    ushort toLivePointSec;                          /* Time in sec from start of IR buffer to current live point */    
    ushort fromLivePoiontToEndOfBufSec;             /* Time from current live point to the end of IR buffer  */
}SXMReplayInfo;

/*************************/
/* SXM RECORDING         */
/* (Host Recording)      */
/*************************/
typedef struct {
    byte status;                                    /* Status of the content (beginning stored ? ending stored ?) */
    ushort trackid;                                 /* ID of this track, assigned by the Module */
    ushort blockid;                                 /* ID of this block, assigned by the Module */
    ushort duration;                                /* Duration of the track in seconds. */
    byte quality;                                   /* An indication of the quality of the recording, ranging from 1 (very poor) to 10 (excellent) */
    ushort sid;                                     /* Service Identifier */
    byte info;                                      /* Provides information about the recording audio content. */
    ushort packetid;                                /* Indicates the PacketID of the first audio packet of this track. */
    byte type;                                      /* Audio encoder used to encode audio content (ACC, AMBE, USAC,...) */
    byte rate;                                      /* Bit Rate used when encoding audio content. */
}SXMRecording;

/* Playback States */
#define SXI_STREAM_INACTIVE         0
#define SXI_STREAM_PAUSED           1
#define SXI_STREAM_BEING_PLAYED     2
#define SXI_STREAM_NAV_FORWARD      3
#define SXI_STREAM_NAV_BACKWARD     4

/***************************/
/* SXM REPLAY          .   */
/* (Module Instant Replay) */
/* (Module Recording)      */
/***************************/
typedef struct {
    byte state;                                     /* playback state (stream inactive,stream pause,...) */
    byte position;                                  /* Current playback position (a percentage of the total IR buffer size) */
    ushort id;                                      /* The playback ID of this track, assigned by the Module */
    ushort duration;                                /* Duration of the currently playing track in seconds */
    ushort times;                                   /* Time that has elapsed from the start of the playing track */
    ushort tracks;                                  /* Indicates the number of tracks remaining in the audio buffer being played */
    ushort timer;                                   /* Indicates the total number of seconds of stored content remaining in 
                                                       the audio buffer being played. */
    ushort timeb;                                   /* Indicates the total number of seconds of stored content in the audio
                                                       buffer prior to the current play point. */
}SXMReplay;

/***************************/
/* SXM TRACK ID STATUS DUR */
/* (Module Instant Replay) */
/***************************/
typedef struct {
    ushort duration;                                /* Duration of the currently playing track in seconds */
}SXMTrackDur;

/* Content Storage Status */
#define SXI_TRACK_END_STORED        0x10
#define SXI_TRACK_BEGIN_STORED      0x08

/***************************/
/* SXM TRACK ID STATUS     */
/* (Module Instant Replay) */
/***************************/
typedef struct {
    ushort id;                                      /* The playback ID of this track, assigned by the Module */
    byte status;                                    /* Status of the content (beginning stored ? ending stored ?) */
} SXMTrackIdStatus;

/***************************/
/* SXM BULLETIN STATUS     */
/***************************/
typedef struct {
    byte type;                                      /* The type of service (Traffic/Weather Now) */
    ushort eventid;                                 /* A unique handle assigned to a Bulletin for
                                                       communicating status to the Host and allowing
                                                       the Host to select the desired event. */
    ushort paraml;                                  /* Unique parameter with interpretation dependent on the type */
    byte status;                                    /* bulletin status (No bulletin, New bulletin, Played butlletin...) */
} SXMBulletinStatus;

/* Flash Type */
#define SXI_SPORTS_FLASH                0x00

/***************************/
/* SXM FLASH STATUS        */
/***************************/
typedef struct {
    ushort channel;                                 /* channel number */
    ushort sid;                                     /* SID */
    uint pid;                                       /* Program Identifier */
    byte chattr;                                    /* Attributes of the channel(SmartFavorites, Mature,...,etc) */
    byte type;                                      /* flash type: 0 - Sports Flash */
    byte status;                                    /* Indicates the status of Flash event being reported (Alert,Expiry,Played,...) */
    ushort eventid;                                 /* A unique handle assigned to a Flash Event for 
                                                       communicating status to the Host and allowing the 
                                                       Host to select the desired event. */
    uint eventdata;                                 /* Reports data for the Flash Event. Interpretation of this field 
                                                       depends on the type of Flash Event reported, */
#if (!SXM_USE_GEN8)
    char names[SXI_CHAN_NAME_SHORT_MAX];            /* Channel Name, Short format */
    char namem[SXI_CHAN_NAME_MED_MAX];              /* Channel Name, Medium format */
    char namel[SXI_CHAN_NAME_LONG_MAX];             /* Channel Name, Long format */
#endif
} SXMFlashStatus;

/*****************************************/
/* SIGNAL VALID BITS                     */
/*****************************************/
#define SIGNAL_STATUS_BARS_ANTENNA_VALID_BIT        (0)
#define ANTENNA_AIMING_VALID_BIT                    (1)
#define DECODER_BITRATE_VALID_BIT                   (2)
#define AUDIO_PRESENCE_VALID_BIT                    (3)
#define SIGNAL_QUALITY_VALID_BIT                    (4)
#define OVERLAY_SIGNAL_QUALITY_VALID_BIT            (5)

/*************************/
/* SXM SIGNAL            */
/*************************/
typedef struct {
    byte signal_strength;   //!< Signal Strength
    byte tuner_status;      //!< Tuner Status
    byte ensa_lock_status;  //!< ENSA Lock Status
    byte ensb_lock_status;  //!< ENSB Lock Status
    ushort ber_s1;          //!< BER S1: 0 to 100 % (in tenths of percent)
    ushort ber_s2;          //!< BER S2: 0 to 100 % (in tenths of percent)
    ushort ber_t;           //!< BER T: 0 to 100 % (in tenths of percent)
    byte cn_s1a;            //!< C/N S1A
    byte cn_s1b;            //!< C/N S1B
    byte cn_s2a;            //!< C/N S2A
    byte cn_s2b;            //!< C/N S2B
    ushort rse_words;       //!< RSErrs Words: The averaged rate of uncorrectable words. (in tenths of percent)
    ushort rse_sat_symb;    //!< RSErrs Sat Symb: The averaged symbol error rate of the RS decoder of the satellite channels (in tenths of percent).
    ushort rse_terr_symb;   //!< RSErrs Terr Symb: The averaged symbol error rate of the RS decoder of the terrestrial channels (in tenths of percent).
    short tuner_freq_off;   //!< Tuner Carrier Frequency Offset: Offset is reported in units of Hz with a minimum step size of 100 Hz. For example, a value of 1 reports a 100 Hz offset and a value of 10 reports a 1000 Hz. The expected range is +/- 80 kHz.
    short rssi;             //!< Received Signal Strength Indication (RSSI) in units of dBm with range from 0 to -128 dBm
} SXMSignalQuality;

typedef struct {
    byte receiver_state;    //!< Receiver State
    ushort ober_s1a;        //!< OBER S1A: 0 to 100 %. (in tenths of percent)
    ushort ober_s2a;        //!< OBER S2A: 0 to 100 %. (in tenths of percent)
    ushort ober_ta;         //!< OBER TA: 0 to 100 %. (in tenths of percent)
    ushort ober_s1b;        //!< OBER S1B: 0 to 100 %. (in tenths of percent)
    ushort ober_s2b;        //!< OBER S2B: 0 to 100 %. (in tenths of percent)
    ushort ober_tb;         //!< OBER TB: 0 to 100 %. (in tenths of percent)
    ushort pipe_0a;         //!< Turbo Word Error Rate (Pipe 0A): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
    ushort pipe_1a;         //!< Turbo Word Error Rate (Pipe 1A): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
    ushort pipe_2a;         //!< Turbo Word Error Rate (Pipe 2A): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
    ushort pipe_0b;         //!< Turbo Word Error Rate (Pipe 0B): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
    ushort pipe_1b;         //!< Turbo Word Error Rate (Pipe 1B): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
    ushort pipe_2b;         //!< Turbo Word Error Rate (Pipe 2B): The averaged rate of uncorrectable words. 0 to 100 % (in tenths of percent); 999.9% for inactive pipe.
} SXMOverlaySignalQuality;

typedef struct {
    byte valid;                               /* which signal parameter (bars, antenna, aim1,..) was been received */
    byte bars;                                /* report signal status (Very Weak, Weak,...,Good)*/
    byte antenna;                             /* report antenna status (ANT OK, ANT DISCONNECTED,...) */
    byte aim1;                                /* Antenna Aiming - calculated received signal level of the satellite signal */
    byte aim2;                                /* Antenna Aiming - calculated received signal level of the terrestrial signal */
    byte bitrate;                             /* audio decoder bitrate */
    byte audio_presence;                      /* audio presence bit 0 - audio not present, 1 - audio present */
    SXMSignalQuality quality;                 /* Normal Signal Quality information needed for TA1 */
    SXMOverlaySignalQuality overlay_quality;  /* Overlay Signal Quality information needed for TA1 */
}SXMSignal;


/*************************/
/* SXM TEAM              */
/*************************/
#if (!SXM_USE_GEN8)
#if (!SXM_USE_GMD)
typedef struct {
    int id;                                         /* SXI_GMI_SPORTS_TEAM_ID */
    char sn[SXI_TEAM_ABBREVIATION_MAX];             /* SXI_GMI_SPORTS_TEAM_ABBREVIATION */
    char mn[SXI_TEAM_NICKNAME_MAX];                 /* SXI_GMI_SPORTS_TEAM_NICKNAME */
    char ln[SXI_TEAM_NAME_MAX];                     /* SXI_GMI_SPORTS_TEAM_NAME */
    char cnt;                                       /* League/Tier count */
    char sports[MAX_LEAGUE_PER_TEAM];               /* SXI_GMI_SPORTS_TEAM_LEAGUE_ID */
    char tiers[MAX_TIER_PER_TEAM];                  /* SXI_GMI_SPORTS_TEAM_TIER_LIST */
}SXMTeam;
#endif
#endif

/*************************/
/* SXM TRAFFIC           */
/*************************/
#if (!SXM_USE_GEN8)
#if (!SXM_USE_GMD)
typedef struct {
    byte id;                                            /* SXI_GMI_TRAFFIC_WEATHER_ID */
    char abbr[SXI_TRAFFIC_WEATHER_ABBREVIATION_MAX];    /* SXI_GMI_TRAFFIC_WEATHER_ABBREVIATION */
    char full[SXI_TRAFFIC_WEATHER_NAME_MAX];            /* SXI_GMI_TRAFFIC_WEATHER_NAME */
}SXMTraffic;
#endif
#endif

/*************************/
/* SXM Buffered Content  */
/*************************/
typedef struct {
    int sid;                                                    /* SID */
    byte programIDCnt;                                          /* ProgramIDCnt */
#if (!SXM_USE_GEN8)
    uint pidList[SXI_BUFFERED_CONTENT_MAX_PIDS_PER_CHANNEL];    /* ProgramIDList[ProgramIDCnt] */
#else
    uint pidList[NUMBER_OF_CUTS_MAX];
#endif
}SXMContentBuf;

/*************************/
/* SDK CALLBACK TYPES    */
/*************************/
/** \name General Purpose Types
 * @{
 */
enum {
    SXM_CALLBACK_ERROR            = 0,
    SXM_CALLBACK_SUBS             = 4,
    SXM_CALLBACK_TIME             = 5,
    SXM_CALLBACK_CONN_READY       = 6
};
/** @} */

/** \name GMD Layer Types
 * @{
 */
#define SXM_CALLBACK_GMD                33
/** @} */

/** \name Sports Layer Types
 * @{
 */
#define SXM_CALLBACK_SPORTS             100
#define SXM_CALLBACK_SPORTS_UPDATING    101
#define SXM_CALLBACK_SPORTS_UPDATED     102
/** @{ */

/** Stocks layer types
 * @{
 */
#define SXM_CALLBACK_STOCKS             200
/** @} */

/** \name FWU Layer Types
 * @{
 */
#define SXM_CALLBACK_FWU_RESULT         300
#define SXM_CALLBACK_FWU_PROGRESS       301
#define SXM_CALLBACK_FWU_RADIO_INFO     302
/** @} */

/** Misc Types
 * @{
 */
//! General progress update callback. The corresponding param is  -1 for progress unknown, or 0 - 1000 for the percentDone*10
#define SXM_CALLBACK_PROGRESS           500
//! Data service DB update notification callback
#define SXM_CALLBACK_DB_UPDATED         501
//! EV data service LOGO update notification callback
#define SXM_CALLBACK_EV_LOGO_UPDATED    502
//! Generic Data service notification callback for new packet
#define SXM_CALLBACK_GD_DATA            503
/** This callback type identifies tier type for specific service */
#define SXM_CALLBACK_TIER               504
/** @} */

/*************************/
/* LINK SERVICE          */
/*************************/
/****************************/
/* SXM Link Extended Stats  */
/****************************/
typedef struct {
    uint drop_bytes;          //!< Out of synchronization  byte count
    uint seq_error;           //!< Number of errors in the received link packet sequence number
    uint chksum_error;        //!< Number of checksum errors in the received link packets
    uint len_error;           //!< Number of payload length errors in the received link packets
    uint type_error;          //!< Number of payload type errors in the received link packets
    uint link_count;          //!< Number of received link messages
    uint sxi_count;           //!< Number of received SXI messages
    uint data_count;          //!< Number of received data packets
    uint keep_alive_count;    //!< Number of keep alive messages received
    uint audio_count;         //!< Number of transmitted audio packets
    uint link_error;          //!< Number of link messages dropped by upper layer
    uint sxi_error;           //!< Number of sxi messages dropped by upper layer
    uint data_error;          //!< Number of data messages dropped by upper layer
} SXMLinkExtendedStats;

extern SXESDK_API int sxm_link_stats(void);

extern SXESDK_API int sxm_link_loss_detection_enable(BOOL isActive);

extern SXESDK_API int sxm_link_extract_resp(byte *resp);

extern SXESDK_API int sxm_link_extract_err(byte *err);

extern SXESDK_API int sxm_link_extract_stat(uint *stat);

extern SXESDK_API int sxm_link_extract_ext(SXMLinkExtendedStats *ext);


/*************************/
/* PPOIs                 */
/*************************/
/**
 * \name Filters for Location extraction
 * @{
 */
/** Defines that location is from PPOI list */
#define SXM_LOCATION_IS_IN_PPOIS         (0x0100)
/** Defines that location is from Collection Area */
#define SXM_LOCATION_IS_IN_COLLECTION    (0x0200)
/** Defines that location is from Extraction MBR */
#define SXM_LOCATION_IS_IN_EXTRACTION    (0x0400)
/** Defines that any location should be extracted */
#define SXM_LOCATION_ALL                 (0x0000)
/** @} */

/** \name Defines extraction masks
 * @{
 */
#define POI_EXT_ALL_REGION_BIT (0)
#define POI_EXT_HAS_VALID_MBR_BIT (1)
/** @} */

/** Defines PPOI description structure */
typedef struct {
    uint ppoi_id;    //!< Unique station id. 
    byte type_flags; //!< PPOI associated custom flags
} PPOISpec;

#ifdef __cplusplus
}
#endif

#endif


/********************************************************************************/







