/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/***************************************************************************//**
 * 
 * \file sxm_iomanager.h
 * \author Alexander Pylchagin
 * \date 8/8/2017
 * \brief I/O Manager Public Interface
 *
 ******************************************************************************/

#ifndef SXM_IOMANAGER_H_
#define SXM_IOMANAGER_H_

#include "sxm_build.h"
#include "sxm_typ.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Specified commands */
typedef enum _smx_iomanager_command_enum {
    /** Stimulates the manager to start saving the data
     * through the list of component regardless quotas
     * utilization.
     */
    SXM_IOMANAGER_FORCE_SAVE = 0,
    /** Pauses the processing. After that no saving operations
     * will be performed until un-pause command.
     */
    SXM_IOMANAGER_PAUSE,
    /** Resumes previously paused processing. */
    SXM_IOMANAGER_RESUME
} SXMIOManagerCommand;

SXESDK_API int sxm_iomanager_set_debug(int debugLevel);

SXESDK_API int sxm_iomanager_command(SXMIOManagerCommand cmd);

#ifdef __cplusplus
}
#endif

#endif /* SXM_IOMANAGER_H_ */
