/******************************************************************************/
/*                Copyright (c) Sirius XM Satellite Radio, Inc.               */
/*                            All Rights Reserved                             */
/*      Licensed Materials - Property of Sirius XM Satellite Radio, Inc.      */
/******************************************************************************/
/*****************************************************************************//**
 * \file sxm_image.h
 * \author Alexander Pylchagin
 * \date 7/03/2017
 *
 * Header for the SXe Image API.
 ********************************************************************************/
#ifndef SXM_IMAGE_H_
#define SXM_IMAGE_H_

#include <stdlib.h>
#include <sxm_build.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Defines image format */
typedef enum {
    SXM_IMAGE_UNKNOWN = 0, //!< Unknown format
    SXM_IMAGE_JPEG,        //!< Jpeg
    SXM_IMAGE_PNG          //!< PNG
} SXMImageFormat;

enum {
    /** Defines max size of the supported module name */
    SXM_IMAGE_MODULE_NAME_MAX = 16 + 1,
    /** Defines max size of the supported file name */
    SXM_IMAGE_FILE_NAME_MAX = 64 + 1
};

/** Defines basic image content */
typedef struct _sxm_image_struct {
    SXMImageFormat format; //!< associated image format
    size_t size; //!< Image length in bytes
    struct _sxm_image_desc_struct {
        /** Corresponding file type (\ref sxe_file_page) */
        char type;
        /** Corresponding module (nil-terminated string) */
        char module[SXM_IMAGE_MODULE_NAME_MAX];
        /** Corresponding file name (nil-terminated string) */
        char file[SXM_IMAGE_FILE_NAME_MAX];
    } desc; //!< Image descriptor
} SXMImage;

SXESDK_API int sxm_image_path(const SXMImage *img, char *path, size_t size);
SXESDK_API int sxm_image_content(const SXMImage *img, void *pData, size_t size);

#ifdef __cplusplus
}
#endif

#endif /* SXM_IMAGE_H_ */