/************************************************************************
 *                                                                      *
 *            SXM_BUILD.H                                               *
 *            ===========                                               *
 *                                                                      *
 *                                 Copyright 2013 Sirius XM Radio, Inc. *
 *                                                 All Rights Reserved. *
 *               Licensed Materials - Property of Sirius XM Radio, Inc. *
 *                                                                      *
 *    Control Options for Build Variants                                *
 *                                                                      *
 ************************************************************************/

#ifndef SXM_BUILD_H
#define SXM_BUILD_H


//Bosch ID#23: To use only sports service for SMSe
#if defined(SXM_USE_SMS)
#ifndef SXM_USE_FUEL
#define SXM_USE_FUEL            0
#endif
#ifndef SXM_USE_CANFUEL
#define SXM_USE_CANFUEL         0
#endif
#ifndef SXM_USE_APOGEE
#define SXM_USE_APOGEE          0
#endif
#ifndef SXM_USE_APOGEE_FULL
#define SXM_USE_APOGEE_FULL     0
#endif
#ifndef SXM_USE_PARKING
#define SXM_USE_PARKING         1
#endif
#ifndef SXM_USE_SPORTS
#define SXM_USE_SPORTS          1
#endif

#define SXM_USE_AUDIO           0
#define SXM_USE_EPG             0
#define SXM_USE_EV              0
#define SXM_USE_IGS             0
#define SXM_USE_IVSM            0
#define SXM_USE_LINK            0
#define SXM_USE_MOVIES          0
#define SXM_USE_PHONETICS       0
#define SXM_USE_PIX             0
#define SXM_USE_RFD             0
#define SXM_USE_SAFETY          0
#define SXM_USE_SOTA            0
#define SXM_USE_STOCKS          0
#define SXM_USE_SXI             0
#define SXM_USE_TRAFFIC         0
#define SXM_USE_V2V             0
#define SXM_USE_WXAGW           0
#define SXM_USE_WXALERTS        0
#define SXM_USE_WXMA            0
#define SXM_USE_WXTAB           0
#define SXM_USE_SUBNOTIFICATION 0
#define SXM_USE_DISTRIBUTED_SXE 0
#define SXM_USE_FWU             0
#define SXM_USE_GD              0
#define SXM_USE_SDKFILES        0
/* design decision for now is that the channel-category logo data services 
and background category image data service is part of the WBMD feature set. 
Therefore, WBMD complier switch controls whether these data services 
are enabled or disabled. */
#define SXM_USE_WBMD            0
#define SXM_USE_CCLOGO          SXM_USE_WBMD
#define SXM_USE_BCATIMAGE       SXM_USE_WBMD
#define SXM_USE_SPORTSLOGO      SXM_USE_WBMD
#define SXM_USE_GMD             SXM_USE_WBMD
#define SXM_USE_PROMO           SXM_USE_WBMD
#define SXM_USE_WBMD_IR         SXM_USE_WBMD
#define SXM_USE_WBMD_AUDIO      SXM_USE_WBMD
#define SXM_USE_GEN8             0
#else
#ifndef SXM_USE_GEN8
#define SXM_USE_GEN8           0
#endif
#ifndef SXM_USE_FUEL
#define SXM_USE_FUEL            1
#endif
#ifndef SXM_USE_CANFUEL
#define SXM_USE_CANFUEL         1
#endif
#ifndef SXM_USE_APOGEE_FULL
#define SXM_USE_APOGEE_FULL     0
#endif

/* APOGEE TRAFFIC (FULL) */
#if SXM_USE_APOGEE_FULL
#  ifdef SXM_USE_APOGEE
#    undef SXM_USE_APOGEE
#  endif
#  define SXM_USE_APOGEE        1
#elif !defined SXM_USE_APOGEE
#  define SXM_USE_APOGEE      1
#endif

#ifndef SXM_USE_AUDIO
#define SXM_USE_AUDIO           1
#endif

/* GEN 7.5 FIRMWARE UPDATE */
#if (SXM_USE_GEN8 == 1)
#  ifdef SXM_USE_FWU
#    undef SXM_USE_FWU
#  endif
#  define SXM_USE_FWU           0
#elif !defined SXM_USE_FWU
#  define SXM_USE_FWU           1
#endif

/* GEN8 FIRMWARE UPDATE */
#if (SXM_USE_GEN8 == 0)
#  ifdef SXM_USE_FWU8
#    undef SXM_USE_FWU8
#  endif
#  define SXM_USE_FWU8           0
#elif !defined SXM_USE_FWU8
#  define SXM_USE_FWU8           1
#endif

/* CODE UPDATE DATA SERVICE FIRMWARE UPDATE */
#if (SXM_USE_GEN8 == 0)
#  ifdef SXM_USE_CUDS
#    undef SXM_USE_CUDS
#  endif
#  define SXM_USE_CUDS          0
#elif !defined SXM_USE_CUDS
#  define SXM_USE_CUDS          1
#endif

#ifndef SXM_USE_EPG
#define SXM_USE_EPG             1
#endif
#ifndef SXM_USE_EV
#define SXM_USE_EV              1
#endif

/* GEN 7.5 CHANNEL GRAPHICS */
#if (SXM_USE_GEN8 == 1)
#  ifdef SXM_USE_IGS
#    undef SXM_USE_IGS
#  endif
#  define SXM_USE_IGS           0
#elif !defined SXM_USE_IGS
#  define SXM_USE_IGS           1
#endif

#ifndef SXM_USE_IVSM
#define SXM_USE_IVSM            1
#endif
#ifndef SXM_USE_LINK
#define SXM_USE_LINK            1
#endif
#ifndef SXM_USE_MOVIES
#define SXM_USE_MOVIES          1
#endif
#ifndef SXM_USE_PARKING
#define SXM_USE_PARKING         1
#endif
#ifndef SXM_USE_PHONETICS
#define SXM_USE_PHONETICS       1
#endif
#ifndef SXM_USE_PIX
#define SXM_USE_PIX             1
#endif
#ifndef SXM_USE_RFD
#define SXM_USE_RFD             1
#endif
#ifndef SXM_USE_SAFETY
#define SXM_USE_SAFETY          1
#endif
#ifndef SXM_USE_SPORTS
#define SXM_USE_SPORTS          1
#endif
#ifndef SXM_USE_STOCKS
#define SXM_USE_STOCKS          1
#endif
#ifndef SXM_USE_SXI
#define SXM_USE_SXI             1
#endif
#ifndef SXM_USE_TRAFFIC
#define SXM_USE_TRAFFIC         0
#endif
#ifndef SXM_USE_V2V
#define SXM_USE_V2V             1
#endif
#ifndef SXM_USE_WXAGW
#define SXM_USE_WXAGW           1
#endif
#ifndef SXM_USE_WXALERTS
#define SXM_USE_WXALERTS        1
#endif
#ifndef SXM_USE_WXMA
#define SXM_USE_WXMA            1
#endif
#ifndef SXM_USE_WXTAB
#define SXM_USE_WXTAB           1
#endif

/* SUB-NOTIFICATION */
#if (SXM_USE_GEN8 == 1)
#  ifdef SXM_USE_SUBNOTIFICATION
#    undef SXM_USE_SUBNOTIFICATION
#  endif
#  define SXM_USE_SUBNOTIFICATION          0
#elif !defined SXM_USE_SUBNOTIFICATION
#  define SXM_USE_SUBNOTIFICATION          1
#endif

#ifndef SXM_USE_GD
#define SXM_USE_GD              1
#endif
#ifndef SXM_USE_SDKFILES
#define SXM_USE_SDKFILES        1
#endif

/* design decision for now is that the channel-category logo data services 
and background category image data service is part of the WBMD feature set. 
Therefore, WBMD complier switch controls whether these data services 
are enabled or disabled. */
#ifndef SXM_USE_WBMD
#define SXM_USE_WBMD            1
#endif
#ifdef SXM_USE_CCLOGO
#undef SXM_USE_CCLOGO
#endif
#ifdef SXM_USE_BCATIMAGE
#undef SXM_USE_BCATIMAGE
#endif
#ifdef SXM_USE_SPORTSLOGO
#undef SXM_USE_SPORTSLOGO
#endif
#ifdef SXM_USE_GMD
#undef SXM_USE_GMD
#endif
#ifdef SXM_USE_WBMD_IR
#undef SXM_USE_WBMD_IR
#endif
#ifdef SXM_USE_WBMD_AUDIO
#undef SXM_USE_WBMD_AUDIO
#endif
#define SXM_USE_CCLOGO          SXM_USE_WBMD
#define SXM_USE_BCATIMAGE       SXM_USE_WBMD
#define SXM_USE_SPORTSLOGO      SXM_USE_WBMD
#define SXM_USE_GMD             SXM_USE_WBMD
#define SXM_USE_WBMD_IR         SXM_USE_WBMD
#define SXM_USE_WBMD_AUDIO      SXM_USE_WBMD
#endif

/* Promo Pass requires WBMD service to be present, so if there is no WBMD then make
   sure Promo Pass is also not present, otherwise it is optional */
   
#ifndef SXM_USE_PROMO
#  define SXM_USE_PROMO           SXM_USE_WBMD
#elif (SXM_USE_WBMD == 0)
#  undef SXM_USE_PROMO
#  define SXM_USE_PROMO           0   
#endif

/* Enable packet metrics debug code to be inserted into data services.
 * CLI command "list stats" is used to display metrics.
 * (service)_packets:  The number of complete Access Units received
 * (service)_bytes:    The number of bytes received via Access Units
 */
#ifdef _DEBUG
#define SXM_DEBUG_PKT_METRICS
#endif

/** Enables memory metrics debug code to be used for all heap operations
 * -# 0 - disabled
 * -# 1 - basic tracking
 * -# 2 - extended with call traces
 */
#ifndef SXM_DEBUG_MEMORY_TRACKING
#define SXM_DEBUG_MEMORY_TRACKING (0)
#endif

/* Detect the Windows build if that platform has not been
 * chosen as SXe expects
 */
#if !defined(WIN32) && (defined(_WIN32) || defined(__WIN32) || defined(__WIN32__))
#define WIN32
#endif

#ifdef WIN32
    #define SXE_INLINE __inline

    #if defined _MSC_VER && defined SXESDK_SHARED
        #ifdef SXESDK_EXPORT
            #define SXESDK_API __declspec(dllexport)
            #define SXESDK_INTERNAL_API __declspec(dllexport)
        #else
            #define SXESDK_API __declspec(dllimport)
            #define SXESDK_INTERNAL_API __declspec(dllimport)
        #endif
    #else
        #define SXESDK_API
        #define SXESDK_INTERNAL_API
    #endif
#else
    #define SXE_INLINE inline
    #define SXESDK_API
    #define SXESDK_INTERNAL_API
#endif

#ifdef _MSC_VER
#define DEPRECATED __declspec(deprecated)
#elif (defined(__GNUC__) && ((__GNUC__ > 4) || ((__GNUC__ == 4) && (__GNUC_MINOR__ >= 6)))) /* GCC >= 4.6.0 */
/* GCC older than 4.6.0 doesn't have a convenient way to suppress deprecated api usage warning */
#define DEPRECATED __attribute__((__deprecated__))
#else
#define DEPRECATED
#endif

/********************************************************************//**
 *
 *            Stack Size Choice
 *
 *            
 *   Selecting stack size for threads created inside the library.
 *   Zero (0) value means default sizes defined by OS are to be used.
 *   Any non-zero number causes thread stack sizes to be enforced to be
 *   not less than that value in bytes. 
 *   See \ref pthread_attr_setstacksize() for details
 *   
 ************************************************************************/
#ifndef SXM_STACK_SIZE_DEFAULT
#define SXM_STACK_SIZE_DEFAULT (0)
#endif

/********************************************************************//**
 *
 *            File and Devices Paths Memory Location
 *            
 *   Selecting the way of the file and device paths allocation mechanism.
 *   By default SXe utilizes the stack to keep memory for path during
 *   generation via calling make path or make dev routines which are
 *   provided via \ref sxm_sdk_start function.
 *   \note The stack size shall be enough to keep two copies of the
 *         path.
 *   
 ************************************************************************/
#ifndef SXM_FILE_PATH_HEAP_ALLOCATION
#define SXM_FILE_PATH_HEAP_ALLOCATION (0)
#endif

#ifndef SXE_FILE_PATH_MAX_SIZE
/** Sets the size of char arrays that SXe uses to hold file path strings.
 * This size includes the NUL-terminator, so the max \c strlen() for a file path
 * is 1 less than this value.
 * \see SXMMakePathCallback_t
 */
#define SXE_FILE_PATH_MAX_SIZE   128
#endif

/********************************************************************//**
 *
 *            FIX Choice
 *
 *    For native mode, we include "math.h" as well (for cos etc)
 *
 *    - typedef fix FLOAT     to use the portable fixpoint library
 *    - typedef float FLOAT   to use native floating-point hardware
 *
 ************************************************************************/
#ifndef SXM_USE_FIX
#define SXM_USE_FIX             0
#endif

/************************************************************************
 *                                                                      *
 *            Driver Choice                                             *
 *            =============                                             *
 *                                                                      *
 *    #define SXM_HAL	for driver in application                       *
 *                                                                      *
 ************************************************************************/

#if !defined(SXM_USE_SMS)
#define SXM_HAL
#endif

#ifdef SXM_HAL
// Define default connection speed.
// If different speed setting is required by particular implementation
// it may be specified at compile time via -DSXM_LNK_BAUD_INDEX=X
// where X - speed index.
// For more details see HAL API and 
// additional definitions in /sdk/include/sxm_link.h
#ifndef SXM_LNK_BAUD_INDEX
#define SXM_LNK_BAUD_INDEX SXM_LNK_BAUD_INDEX_115200
#endif

#endif //SXM_HAL

/************************************************************************
 *                                      
 *            SXM Pix Settings
 *            ==========
 *
 * Description: The user must select options for Pix compilation. The following
 *              settings must be selected (See UIRR for more details).
 *              Enable one setting for each of the following:
 *              Real Time Settings : RT-A = Images for all SIDs buffered in real-time.
 *                                 : RT-B = Images for Favorites buffered in real-time.
 *                                 : RT-C = Images for current SID buffered in real-time.
 *
 *              Buffered Content   : BF = Save images for buffered content. Images will be
 *                                   saved based on the RT selection. If RT-A or RT-B is selected 
 *                                   then all Smart Favorites will be buffered. If RT-C is 
 *                                   selected then images are buffered for the current SID only.
 *
 *              Channel Default     : CD-A = Channel Default Images and Updates are supported.
 *                                    CD-B = Channel Default Images not supported.
 *
 *              Service Default     : SD-A = Service Default Image and Updates are supported.
 *                                    CD-B = Service Default Image is supported.
 *
 ************************************************************************/
#if SXM_USE_PIX
#define SXM_PIX_RT_A                1
#define SXM_PIX_RT_B                0
#define SXM_PIX_RT_C                0

#define SXM_PIX_BF                  1

#define SXM_PIX_CD_A                1
#define SXM_PIX_CD_B                0

#define SXM_PIX_SD_A                1
#define SXM_PIX_SD_B                0
#endif

#define SXM_PIX_BUFF_CNT_ENABLED    1

/************************************************************************
 *                                      
 *            SXM WbMetadata Settings
 *            ==========
 *
 * Description: The user must select options for WbMetadatr compilation. The following
 //TODO: figure out if needed.....................................................................
 *
 ************************************************************************/
/* define if wideband (layer 0 - 3) or narrowband (layer 0 - 1) are used 
   SXM_USE_WIDEBAND 1 = use wideband
   SXM_USE_WIDEBAND 0 = use narrowband 
   */
#ifndef SXM_USE_WIDEBAND
#if SXM_USE_GEN8
#define SXM_USE_WIDEBAND            1
#else
#define SXM_USE_WIDEBAND            0
#endif
#endif

/************************************************************************
 *
 *            PPOI Configurations
 *            ===================
 *
 * This section defines specific PPOI configuration for each data service
 *
 ************************************************************************/
#ifndef SXM_PPOI_MAX
/** Defines max number of PPOI locations supported by the Parking/Fuel/CanFuel/Ev data
 * services.
 * \warning This number impacts NVM and RAM usage
 */
#define SXM_PPOI_MAX (2048)
#endif

#ifndef SXM_MOVIES_PPOI_MAX
/** Defines max number of PPOI locations supported by the Movies data
 * service.
 * \warning This number impacts NVM and RAM usage
 */
#define SXM_MOVIES_PPOI_MAX (256)
#endif

#endif
