/************************************************************************
 *                                                                      *
 *            STRING.C                                                  *
 *            ========                                                  *
 *                                                                      *
 ************************************************************************/

#include <ctype.h>
#include "sdkfiles.h"


#ifdef _MSC_VER    
    #define strcasecmp _stricmp
    #define strncasecmp _strnicmp
#endif

//  advance 'in' until a char NOT in 'chars' is found, or end-of-string
//  return the updated 'in' pointer.

static String strskipover(String in,
                   String chars) {
    while (*in && (strchr(chars, *in) != NULL))
        in++;
    return in;
}

//  remove any characters <= ' ' from the start and end of 'in.  Note this
//  may update the data as the terminal NUL may move.
//  return pointer to first printable character (or end-of-string)

String strtrim(String buffer) {
    size_t len;
    String start = buffer;

    len = strlen(buffer);
    while (len > 0 && ((unsigned char)buffer[len-1] <= ' '))
        buffer[--len] = '\0';
    // according to java " ", "\t", "\n", "\f", "\r" are whitespace
    return strskipover(start, " \t\n\f\r");
}

//  split the string into tokens using 'sep' as the separator.
//  return the first 'max' entries into the output array
//  and return the total number of tokens as the return value
//  Note this this destroys the input string

uint strsplit(String input,
             char sep,
             String output[],
             uint max) {
    uint ix = 0;

    output[ix++] = input;
    while (*input) {
        if  (*input == sep) {
            *input++ = '\0';
            if  (ix < max) {
                output[ix] = input;
            }
            ix++;
        } else {
            input++;
        }
    }

    return ix;
}
