/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SXILL Ring Buffer header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef SXILL_RINGBUFFER_H_
#define SXILL_RINGBUFFER_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct sxill_ring_buffer_data_struct
{
    size_t tCapacity;
    size_t tSize;
    size_t tStart;
    UN8 *pun8Data;
} SXILL_RING_BUFFER_DATA_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

void SXILL_RB_vInit (
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    void *pvBuffer,
    size_t tBufferSize
        );

void SXILL_RB_vAttach (
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    SXILL_RING_BUFFER_DATA_STRUCT *psMaster
        );

size_t SXILL_RB_tRead(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    void *pData,
    size_t tDataSize
        );

size_t SXILL_RB_tCommit(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    size_t tDataSize
        );

size_t SXILL_RB_tSkip(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    size_t tDataSize
        );

size_t SXILL_RB_tSize(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj
        );

void SXILL_RB_vSolidUnusedBlock(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    UN8 **ppun8Block,
    size_t *ptBlockSize
        );

void SXILL_RB_vSolidUsedBlocks(
    SXILL_RING_BUFFER_DATA_STRUCT *psObj,
    UN8 **ppun8Block1,
    size_t *ptBlock1Size,
    UN8 **ppun8Block2,
    size_t *ptBlock2Size
        );

#endif
